/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.constant;

import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;

public enum CashFlowClassifyEnum {
    ALL("\u5168\u90e8\u6536\u76ca", null, null, UserAccountDTO::getSettledCash),
    REBATE("\u8d2d\u7269\u6536\u76ca", new CashFlowTypeEnum[]{CashFlowTypeEnum.REBATE_CASH, CashFlowTypeEnum.TAKE_OUT_REBATE_CASH}, null, UserAccountDTO::getRebateCash),
    INVITE_VIP("\u5f00\u5361\u6536\u76ca", new CashFlowTypeEnum[]{CashFlowTypeEnum.INVITE_VIP}, null, UserAccountDTO::getInviteVipCash),
    OTHER("\u5176\u4ed6\u6536\u76ca", null, new CashFlowTypeEnum[]{CashFlowTypeEnum.REBATE_CASH, CashFlowTypeEnum.INVITE_VIP, CashFlowTypeEnum.TAKE_OUT_REBATE_CASH}, UserAccountDTO::getOtherCash);

    private String label;
    private CashFlowTypeEnum[] include;
    private CashFlowTypeEnum[] exclude;
    private AccountField accountField;

    private CashFlowClassifyEnum(String label, CashFlowTypeEnum[] include, CashFlowTypeEnum[] exclude, AccountField accountField) {
        this.label = label;
        this.include = include;
        this.exclude = exclude;
        this.accountField = accountField;
    }

    public BigDecimal getAccountField(UserAccountDTO userAccount) {
        return this.accountField.get(userAccount);
    }

    public String getLabel() {
        return this.label;
    }

    public CashFlowTypeEnum[] getInclude() {
        return this.include;
    }

    public CashFlowTypeEnum[] getExclude() {
        return this.exclude;
    }

    public static CashFlowClassifyEnum of(String name) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        for (CashFlowClassifyEnum value : CashFlowClassifyEnum.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    static interface AccountField {
        public BigDecimal get(UserAccountDTO var1);
    }
}

