/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.invite.bind;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.domain.UserInviteHistoryMapper;
import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.facade.MerchantFeignService;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.localnews.user.invite.bind.AbstractBindInviteStrategy;
import com.bxm.newidea.component.vo.Message;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActiveCodeBindMethod
extends AbstractBindInviteStrategy {
    private static final Logger log = LoggerFactory.getLogger(ActiveCodeBindMethod.class);
    @Autowired
    private InviteRecordService inviteRecordService;
    @Autowired
    private UserInviteHistoryMapper userInviteHistoryMapper;
    @Autowired
    private MerchantFeignService merchantFeignService;

    @Override
    protected Message preInvoke(UserInviteBindDTO userInviteBindDTO) {
        if (userInviteBindDTO.getAlreadyHas().booleanValue()) {
            userInviteBindDTO.setNeedUpdate(Boolean.valueOf(true));
        } else {
            if (userInviteBindDTO.getActiveCodeHasTime().booleanValue()) {
                userInviteBindDTO.getUserInviteHistoryBean().setActiveVip(Byte.valueOf(AppConst.ENABLE.byteValue()));
                userInviteBindDTO.getUserInviteHistoryBean().setState(userInviteBindDTO.getUser().getState());
                userInviteBindDTO.getUserInviteHistoryBean().setRelationTitle(InviteTypeEnum.ACTIVE_CODE.getDesc());
                userInviteBindDTO.getUserInviteHistoryBean().setBindTime(new Date());
                return Message.build((boolean)true);
            }
            this.inviteRecordService.addInviteRecord(userInviteBindDTO.getInviteUserId(), userInviteBindDTO.getUserId(), this.getBindMethod().name());
        }
        return Message.build((boolean)false);
    }

    @Override
    protected void beNormalInviteAfter(UserInviteBindDTO userInviteBindDTO) {
        if (null == userInviteBindDTO.getUserInviteHistoryBean().getActiveVip() || Objects.equals(userInviteBindDTO.getUserInviteHistoryBean().getActiveVip(), AppConst.DISALBE.byteValue())) {
            this.userInviteHistoryMapper.updateInvitedUserIdVip(userInviteBindDTO.getUserId());
            this.merchantFeignService.updateInvitedUserIdVip(userInviteBindDTO.getUserId(), InviteTypeEnum.ACTIVE_CODE.name());
        }
    }

    @Override
    protected InviteBindMethodEnum getBindMethod() {
        return InviteBindMethodEnum.ACTIVE_CODE;
    }
}

