/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.invite.bind;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.domain.InviteRecordMapper;
import com.bxm.localnews.user.domain.UserInviteHistoryMapper;
import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.enums.InviteBindMethodEnum;
import com.bxm.localnews.user.enums.InviteRecordStatusEnum;
import com.bxm.localnews.user.facade.MerchantFeignService;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.localnews.user.invite.bind.AbstractBindInviteStrategy;
import com.bxm.localnews.user.param.InviteRecordParam;
import com.bxm.newidea.component.vo.Message;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WelfareVipBindMethod
extends AbstractBindInviteStrategy {
    private static final Logger log = LoggerFactory.getLogger(WelfareVipBindMethod.class);
    @Autowired
    private InviteRecordService inviteRecordService;
    @Autowired
    private InviteRecordMapper inviteRecordMapper;
    @Autowired
    private UserInviteHistoryMapper userInviteHistoryMapper;
    @Autowired
    private MerchantFeignService merchantFeignService;

    @Override
    protected Message preInvoke(UserInviteBindDTO userInviteBindDTO) {
        if (userInviteBindDTO.getIsCallback().booleanValue()) {
            InviteRecordParam inviteRecordParam = new InviteRecordParam();
            inviteRecordParam.setUserId(userInviteBindDTO.getInviteUserId());
            inviteRecordParam.setInvitedUserId(userInviteBindDTO.getUserId());
            inviteRecordParam.setStatus(InviteRecordStatusEnum.VALID.getStatus());
            List inviteRecordList = this.inviteRecordMapper.queryUserInviteRecord(inviteRecordParam);
            if (!CollectionUtils.isEmpty((Collection)inviteRecordList)) {
                userInviteBindDTO.getUserInviteHistoryBean().setState(Byte.valueOf((byte)1));
                userInviteBindDTO.getUserInviteHistoryBean().setType(userInviteBindDTO.getUser().getRegisterChannel());
                userInviteBindDTO.getUserInviteHistoryBean().setRelationId(userInviteBindDTO.getUser().getRelationId());
                userInviteBindDTO.getUserInviteHistoryBean().setInviteUserId(userInviteBindDTO.getInviteUserId());
                userInviteBindDTO.getUserInviteHistoryBean().setUserId(userInviteBindDTO.getUserId());
                userInviteBindDTO.getUserInviteHistoryBean().setActiveVip(Byte.valueOf(AppConst.ENABLE.byteValue()));
                userInviteBindDTO.getUserInviteHistoryBean().setRelationTitle(InviteTypeEnum.WELFARE_VIP.getDesc());
                return Message.build((boolean)true);
            }
        } else {
            this.inviteRecordService.addInviteRecord(userInviteBindDTO.getInviteUserId(), userInviteBindDTO.getUserId(), this.getBindMethod().name());
        }
        return Message.build((boolean)false);
    }

    @Override
    protected Message afterInviteNormal(UserInviteBindDTO userInviteBindDTO) {
        this.userInviteHistoryMapper.updateInvitedUserIdVip(userInviteBindDTO.getUserId());
        this.merchantFeignService.updateInvitedUserIdVip(userInviteBindDTO.getUserId(), InviteTypeEnum.WELFARE_VIP.name());
        return super.afterInviteNormal(userInviteBindDTO);
    }

    @Override
    protected void beNormalInviteAfter(UserInviteBindDTO userInviteBindDTO) {
        if (null == userInviteBindDTO.getUserInviteHistoryBean().getActiveVip() || Objects.equals(userInviteBindDTO.getUserInviteHistoryBean().getActiveVip(), AppConst.DISALBE.byteValue())) {
            this.userInviteHistoryMapper.updateInvitedUserIdVip(userInviteBindDTO.getUserId());
            this.merchantFeignService.updateInvitedUserIdVip(userInviteBindDTO.getUserId(), InviteTypeEnum.WELFARE_VIP.name());
        }
    }

    @Override
    protected InviteBindMethodEnum getBindMethod() {
        return InviteBindMethodEnum.WELFARE_VIP;
    }
}

