/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.user.dto.NewsBriefInfoDto;
import com.bxm.localnews.user.integration.NewsIntegrationService;
import com.bxm.localnews.user.invite.InviteProcessorContext;
import com.bxm.localnews.user.invite.processor.AbstractInviteTypeProcessor;
import com.bxm.localnews.user.utils.MaxLengthStringBuilder;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsInviteTypeProcessor
extends AbstractInviteTypeProcessor {
    private final NewsIntegrationService newsIntegrationService;

    @Autowired
    public NewsInviteTypeProcessor(NewsIntegrationService newsIntegrationService) {
        this.newsIntegrationService = newsIntegrationService;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.NEWS;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        if (StringUtils.isBlank((CharSequence)inviteHistory.getRelationTitle())) {
            return this.defaultInviteMsg;
        }
        return MaxLengthStringBuilder.builder(this.defaultColumnWidth).appendImmutable("\u5206\u4eab\u7684\u300a").appendDynamic(inviteHistory.getRelationTitle()).appendImmutable("\u300b\u65b0\u95fb").build();
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return "";
        }
        NewsBriefInfoDto newsInfo = this.newsIntegrationService.getNewsInfo(context.getRelationId());
        if (StringUtils.isBlank((CharSequence)newsInfo.getTitle())) {
            return "";
        }
        return newsInfo.getTitle();
    }

    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }
}

