/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.login.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.domain.UserLoginHistoryMapper;
import com.bxm.localnews.user.login.UserLoginHistoryService;
import com.bxm.localnews.user.vo.UserLoginHistory;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserLoginHistoryServiceImpl
extends BaseService
implements UserLoginHistoryService {
    @Resource
    private UserLoginHistoryMapper userLoginHistoryMapper;

    @Override
    @Async
    public void save(UserLoginHistory userLoginHistory) {
        this.userLoginHistoryMapper.insertSelective(userLoginHistory);
    }

    @Override
    public Message isDeviceExist(Long userId, String deviceId) {
        if (null != deviceId) {
            List userLoginHistoryList = this.userLoginHistoryMapper.selectUserByEquipment(userId, deviceId);
            if (CollectionUtils.isEmpty((Collection)userLoginHistoryList)) {
                return Message.build((boolean)false).addParam("equipment", (Object)deviceId);
            }
            return Message.build((boolean)true).addParam("equipment", (Object)deviceId);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message isDeviceExistByDeviceId(Long userId, String deviceId) {
        if (null == userId || org.springframework.util.StringUtils.isEmpty((Object)deviceId)) {
            return Message.build((boolean)true);
        }
        List userLoginHistoryList = this.userLoginHistoryMapper.selectUserByEquipment(userId, deviceId);
        return Message.build((boolean)CollectionUtils.isEmpty((Collection)userLoginHistoryList));
    }

    @Override
    @Async
    public void save(String equipment, BasicParam basicParam, Long userId, String ip) {
        if (PlatformEnum.ANDROID.getCode() == basicParam.getPlatform() || PlatformEnum.IOS.getCode() == basicParam.getPlatform()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u66f4\u65b0\u767b\u5f55\u5386\u53f2\uff0cdevcId:[{}],equipment:[{}]", (Object)basicParam.getDevcId(), JSONObject.toJSON((Object)equipment));
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{equipment})) {
                this.save(UserLoginHistory.buildUserLoginHistory((Long)this.nextSequence(), (Long)userId, (String)ip, (String)equipment));
            }
        } else if (4 == basicParam.getPlatform() || PlatformEnum.APPLET.getCode() == basicParam.getPlatform()) {
            this.save(UserLoginHistory.buildUserLoginHistory((Long)this.nextSequence(), (Long)userId, (String)ip, (String)basicParam.getDevcId()));
        }
    }

    @Override
    public UserLoginHistory selectFirst(Long userId) {
        return this.userLoginHistoryMapper.selectFirstOrLastOne(userId, 0);
    }

    @Override
    public UserLoginHistory selectLast(Long userId) {
        return this.userLoginHistoryMapper.selectFirstOrLastOne(userId, 1);
    }
}

