/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.login.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.attribute.NoviceTaskRecordService;
import com.bxm.localnews.user.attribute.UserPersonalInfoService;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.LevelEnum;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.exception.UserRepeatCreateException;
import com.bxm.localnews.user.integration.AdvertIntegrationService;
import com.bxm.localnews.user.integration.BizIntegrationService;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.integration.MissionIntegrationService;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.login.UserAuthService;
import com.bxm.localnews.user.login.UserRegistrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.properties.BizConfigProperties;
import com.bxm.localnews.user.support.ChannelService;
import com.bxm.localnews.user.support.ExtendedService;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.jwt.tools.JwtTokenUtil;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.service.BaseService;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.retry.RetryException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class UserRegistrationServiceImpl
extends BaseService
implements UserRegistrationService {
    @Resource
    private UserAuthService userAuthService;
    @Resource
    private NoviceTaskRecordService noviceTaskRecordService;
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private UserMapper userMapper;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private ChannelService channelService;
    @Resource
    private MissionIntegrationService missionIntegrationService;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;
    @Resource
    private UserNewsIntegrationService userNewsIntegrationService;
    @Resource
    private AdvertIntegrationService advertIntegrationService;
    @Resource
    private UserService userService;
    @Resource
    private ExtendedService extendedService;
    @Resource
    private UserPersonalInfoService userPersonalInfoService;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private BizIntegrationService bizIntegrationService;
    @Resource
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    @Override
    @Retryable(value={RetryException.class}, backoff=@Backoff(value=300L))
    public Json<LoginMeta> register(LoginInfo loginInfo, BasicParam basicParam, String firstOpenType) {
        EquipmentDTO equipmentDTO = this.bizIntegrationService.getDevice(basicParam.getDevcId());
        if (equipmentDTO == null || equipmentDTO.getId() == null) {
            return ResultUtil.genFailedResult((String)"\u65e0\u6cd5\u83b7\u53d6\u8bbe\u5907\u53f7\uff0c\u8bf7\u91cd\u8bd5");
        }
        basicParam.setDevcId(equipmentDTO.getId());
        User user = this.userMapper.findByEquipment(equipmentDTO.getId());
        if (null == user) {
            try {
                user = this.addUser(loginInfo, basicParam, (byte)0);
            }
            catch (UserRepeatCreateException e) {
                this.logger.warn("\u91cd\u590d\u521b\u5efa\u7528\u6237\uff0c\u8fdb\u884c\u91cd\u8bd5\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)loginInfo);
                throw new RetryException("\u7528\u6237\u91cd\u590d\u521b\u5efa\uff0c\u91cd\u65b0\u8bf7\u6c42\u4e00\u6b21");
            }
            this.logger.debug(LogMarker.BIZ, "\u7528\u6237\u9759\u9ed8\u6ce8\u518c\u751f\u6210\u9ed8\u8ba4\u9891\u9053\u5217\u8868\uff0cloginInfo:[{}]", (Object)loginInfo);
            this.userNewsIntegrationService.initUserNewsImage(user.getId(), null);
        }
        user.setSex(Byte.valueOf(user.getSex() == null ? (byte)0 : user.getSex()));
        UserInfoDTO dto = this.userService.putUserToRedis(user);
        return ResultUtil.genSuccessResult((Object)new LoginMeta(dto));
    }

    @Override
    public User addUser(LoginInfo loginInfo, BasicParam basicParam, Byte userType) throws UserRepeatCreateException {
        this.logger.info("\u6dfb\u52a0\u65b0\u7528\u6237\u4fe1\u606f:[{}]", (Object)JSON.toJSONString((Object)loginInfo));
        String lockKey = this.nextSequence().toString();
        String lockResource = this.buildLockResource(loginInfo);
        if (this.distributedLock.lock(lockResource, lockKey)) {
            User user = this.saveUser(loginInfo, basicParam, userType);
            if (0 != userType) {
                this.userAuthService.saveAuth(user.getId(), loginInfo);
                this.userAccountService.createUserAccount(user.getId());
                this.noviceTaskRecordService.batchAdd(user.getId());
                this.scheduledThreadPoolExecutor.schedule(() -> {
                    this.missionIntegrationService.asyncCompleteTask(user.getId(), TaskEnum.TASK_FIRST_LOGIN, String.valueOf(user.getId()));
                    this.saveRegSourceInfo(loginInfo, user, basicParam.getChnl());
                    this.advertIntegrationService.triggerAndroidId(loginInfo, basicParam);
                    this.bizLogIntegrationService.createUser(user, basicParam, null);
                }, 3L, TimeUnit.SECONDS);
            }
            this.logger.debug("\u6dfb\u52a0\u7528\u6237\u6210\u529f\uff1a[{}]", (Object)JSON.toJSONString((Object)user));
            this.distributedLock.unlock(lockResource, lockKey);
            return user;
        }
        throw new UserRepeatCreateException();
    }

    private String buildLockResource(LoginInfo loginInfo) {
        if (null == loginInfo || null == loginInfo.getType()) {
            return String.valueOf(this.nextId());
        }
        if (3 == loginInfo.getType()) {
            return loginInfo.getLoginName();
        }
        if (1 == loginInfo.getType()) {
            return loginInfo.getPhone();
        }
        return loginInfo.getLoginName();
    }

    private User saveUser(LoginInfo loginInfo, BasicParam basicParam, Byte userType) {
        int count;
        User user = new User();
        user.setRegisterClient(String.valueOf(basicParam.getPlatform()));
        user.setAge(0);
        user.setSex(Byte.valueOf(loginInfo.getSex() == null ? (byte)0 : loginInfo.getSex()));
        user.setEquipment(basicParam.getDevcId());
        user.setPhone(loginInfo.getPhone());
        user.setRegisteredAddress(loginInfo.getRegisteredaddress());
        user.setState(userType);
        user.setLevel(LevelEnum.INITIAL_USER.getType());
        user.setIsNew(Byte.valueOf((byte)0));
        user.setIsTempNickName(Byte.valueOf((byte)1));
        user.setIsTempHeadImg(Byte.valueOf((byte)1));
        user.setChannelId(this.channelService.getChannelId(basicParam.getChnl()));
        user.setRegIp(loginInfo.getRegIp());
        user.setLastLoginIp(loginInfo.getLastLoginIp());
        user.setNewbieGuideFlag(Byte.valueOf((byte)0));
        user.setCreateTime(new Date());
        if (0 != userType) {
            this.setLoginName(user, loginInfo);
            user.setInfoCompleteState(this.userPersonalInfoService.initUserInfoCompleteStatus(user));
        }
        if ((count = this.userService.createUser(user, basicParam)) > 0) {
            User loginUser = new User();
            loginUser.setId(user.getId());
            loginUser.setToken(JwtTokenUtil.generateToken((Long)user.getId()));
            loginUser.setRefreshtoken(JwtTokenUtil.generateToken((Long)user.getId()));
            loginUser.setExpiretime(Long.valueOf(JwtTokenUtil.generateExpirationDate().getTime()));
            user.setToken(loginUser.getToken());
            user.setRefreshtoken(loginUser.getRefreshtoken());
            user.setExpiretime(loginInfo.getExpiretime());
            this.userMapper.updateByPrimaryKeySelective(loginUser);
        }
        return user;
    }

    private void changeUserLocation(LoginInfo loginInfo, User user, UserMapper userMapper) {
        User originalUser;
        if (null != loginInfo.getId() && null != (originalUser = userMapper.selectByPrimaryKey(loginInfo.getId())) && null != originalUser.getLocationCode() && null != originalUser.getLocationName()) {
            user.setLocationCode(originalUser.getLocationCode());
            user.setLocationName(originalUser.getLocationName());
        }
    }

    private void setLoginName(User user, LoginInfo loginInfo) {
        if (1 == loginInfo.getType()) {
            user.setPhone(loginInfo.getLoginName());
        } else if (2 == loginInfo.getType()) {
            user.setQq(loginInfo.getLoginName());
        } else if (4 == loginInfo.getType()) {
            user.setWeibo(loginInfo.getLoginName());
        } else if (3 == loginInfo.getType()) {
            user.setWeixin(loginInfo.getLoginName());
            user.setNickname(user.getNickname() == null ? EmojiCodeParser.replaceSoftbankEmoji((String)loginInfo.getNickname()) : user.getNickname());
            user.setHeadImg(user.getHeadImg() == null ? this.extendedService.uploadHeadImg(loginInfo.getHeadImg(), user.getId()) : user.getHeadImg());
        } else {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
    }

    private void saveRegSourceInfo(LoginInfo loginInfo, User user, String chnl) {
        Long inviteCode = loginInfo.getInviteCode();
        if (null == inviteCode) {
            return;
        }
        this.logger.debug(LogMarker.BIZ, "\u7528\u6237\u9080\u8bf7\u8bb0\u5f55,loginInfo:[{}],user:[{}],chnl:[{}]", new Object[]{loginInfo, user, chnl});
        this.bizLogIntegrationService.inviteSuccessed(inviteCode, user.getId(), null == user.getRegisterClient() ? null : Integer.valueOf(user.getRegisterClient()));
        this.missionIntegrationService.asyncCompleteTask(inviteCode, TaskEnum.TASK_INVITED_FRIEND, user.getId().toString());
    }
}

