/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.support.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.attribute.UserVisitService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserLocationHistoryMapper;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.domain.UserStatisticsMapper;
import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.enums.ExtraInviteStateEnum;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.localnews.user.event.ActiveActionEvent;
import com.bxm.localnews.user.event.LocationActionEvent;
import com.bxm.localnews.user.event.UserActionEvent;
import com.bxm.localnews.user.integration.AppVersionIntegrationService;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.integration.LocationIntegrationService;
import com.bxm.localnews.user.integration.MessageUserIntegrationService;
import com.bxm.localnews.user.integration.UserNewsIntegrationService;
import com.bxm.localnews.user.invite.UserInviteService;
import com.bxm.localnews.user.login.UserParamCheckService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.model.MerchantUserDTO;
import com.bxm.localnews.user.param.UserLocationParam;
import com.bxm.localnews.user.properties.BizConfigProperties;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.support.UserInternalService;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vip.relation.MerchantRelationService;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserLocationHistory;
import com.bxm.localnews.user.vo.UserVip;
import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.oss.config.AliyunOssProperties;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.google.common.eventbus.EventBus;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UserInternalServiceImpl
extends BaseService
implements UserInternalService {
    private UserAccountService userAccountService;
    private UserMapper userMapper;
    private UserProperties userProperties;
    private RedisStringAdapter redisStringAdapter;
    private UserLocationHistoryMapper userLocationHistoryMapper;
    private LocationIntegrationService locationIntegrationService;
    private AliyunOSSService aliyunOSSService;
    private AliyunOssProperties aliyunOssProperties;
    private BizConfigProperties bizConfigProperties;
    private BizLogIntegrationService bizLogIntegrationService;
    private UserNewsIntegrationService userNewsIntegrationService;
    private AppVersionIntegrationService appVersionIntegrationService;
    private UserParamCheckService userParamCheckService;
    private UserService userService;
    private UserVisitService userVisitService;
    private UserStatisticsMapper userStatisticsMapper;
    private EventBus userActionEventBus;
    private MessageUserIntegrationService messageUserIntegrationService;
    private UserInviteService userInviteService;
    private UserVipService userVipService;
    private MerchantRelationService merchantRelationService;

    @Override
    public LocationDTO doPostingLocation(String code, Long userId, BasicParam basicParam, String ip) {
        Message message = this.userParamCheckService.checkPostLocationParam(code, userId);
        if (!message.isSuccess()) {
            this.logger.error(message.getLastMessage());
        }
        if (null == code) {
            code = this.bizConfigProperties.getLocationCode();
        }
        LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(code);
        if (Objects.equals(this.appVersionIntegrationService.getPublishState(basicParam), Boolean.TRUE)) {
            locationDTO.setEnablePaidPromote(Byte.valueOf((byte)0));
            locationDTO.setEnableCommunityContent(Integer.valueOf(0));
            locationDTO.setEnableIndexPublish(Integer.valueOf(0));
        }
        if (null != userId) {
            locationDTO.setPublishPostNum(this.userNewsIntegrationService.getPublishPostNum(userId));
            if (Objects.equals(this.redisStringAdapter.hasKey(RedisConfig.NEW_USER_LOGIN.copy().appendKey((Object)userId)), Boolean.FALSE)) {
                this.userAccountService.updateInviteUserCash(userId, ExtraInviteStateEnum.LOGIN_TWICE);
            }
            ((UserInternalService)SpringContextHolder.getBean(UserInternalService.class)).afterPostingLocation(locationDTO, userId, basicParam, ip);
        } else {
            locationDTO.setPublishPostNum(Integer.valueOf(0));
        }
        if (Objects.nonNull(basicParam) && StringUtils.isNotBlank((CharSequence)basicParam.getCurVer()) && com.bxm.newidea.component.tools.StringUtils.isGrateOrEqualThan((String)basicParam.getCurVer(), (String)"3.5.0")) {
            locationDTO.setEnableIndexPublish(Integer.valueOf(0));
        }
        return locationDTO;
    }

    @Override
    @Async
    public void afterPostingLocation(LocationDTO locationDTO, Long userId, BasicParam basicParam, String ip) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (null != user && com.bxm.newidea.component.tools.StringUtils.notEquals((CharSequence)user.getLocationCode(), (CharSequence)locationDTO.getCode())) {
            String oldLocationCode = user.getLocationCode();
            user.setLocationCode(locationDTO.getCode());
            user.setLocationName(locationDTO.getName());
            this.userMapper.updateLocationByPrimaryKeySelective(user);
            this.userService.loadUserToRedis(userId);
            UserLocationHistory userLocationHistory = new UserLocationHistory();
            userLocationHistory.setAddTime(new Date());
            userLocationHistory.setId(this.nextSequence());
            userLocationHistory.setLocationCode(locationDTO.getCode());
            userLocationHistory.setUserId(userId);
            this.userLocationHistoryMapper.insert(userLocationHistory);
            this.bizLogIntegrationService.changeArea(userId, locationDTO.getCode(), null);
            if (StringUtils.isNotBlank((CharSequence)locationDTO.getCode())) {
                UserActionEvent userActionEvent = LocationActionEvent.of().setLocationCode(locationDTO.getCode()).setLocationName(locationDTO.getName()).setOldLocationCode(oldLocationCode).setUserId(user.getId());
                this.userActionEventBus.post((Object)userActionEvent);
            }
        } else if (null != user) {
            this.logger.warn("\u7528\u6237\u4f4d\u7f6e\u4fe1\u606f\u53d8\u66f4\u5931\u8d25\uff0c\u7528\u6237ID\uff1a{},\u53d8\u66f4\u540e\u7684\u4f4d\u7f6e:{},\u7528\u6237\u7684\u5f53\u524d\u4f4d\u7f6e\uff1a{}", new Object[]{userId, locationDTO.getCode(), user.getLocationCode()});
        }
    }

    @Override
    public String getUserHeaderImg(Long userId) {
        UserInfoDTO userInfoDTO = this.userService.getUserCache(userId);
        if (userInfoDTO == null) {
            return this.userProperties.getDefaultHeadImgUrl();
        }
        String urlString = userInfoDTO.getHeadImg();
        if (com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)userInfoDTO.getHeadImg())) {
            return this.userProperties.getDefaultHeadImgUrl();
        }
        if (com.bxm.newidea.component.tools.StringUtils.startsWith((CharSequence)urlString, (CharSequence)this.aliyunOssProperties.getCdnUrl())) {
            this.logger.debug("hit cache headimg:{}", (Object)userId);
            return urlString;
        }
        try {
            String fileExt = FileUtils.getFilextension((String)urlString);
            if (FileTypeEnum.getContentType((String)fileExt) == null) {
                fileExt = FileTypeEnum.JPG.getExtName();
            }
            URL url = new URL(urlString);
            BufferedInputStream dis = new BufferedInputStream(url.openStream());
            int hashCode = (int)(userId % 10L);
            String imgUrl = this.aliyunOSSService.upload((InputStream)dis, "avatar/" + hashCode + "/" + userId + "." + fileExt);
            userInfoDTO.setHeadImg(imgUrl);
            this.userService.loadUserToRedis(userId);
            return imgUrl;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public UserBaseInfoDTO getUserPersonalCenterInfo(Long userId, int platform) {
        UserInfoDTO user = this.userService.getUserCache(userId);
        if (null == user) {
            return null;
        }
        UserBaseInfoDTO userBaseInfoDTO = new UserBaseInfoDTO();
        userBaseInfoDTO.setNickname(com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)user.getNickname()) ? com.bxm.newidea.component.tools.StringUtils.hideMobile((String)user.getPhone()) : user.getNickname());
        userBaseInfoDTO.setHeadImg(com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)user.getHeadImg()) ? this.userProperties.getDefaultHeadImgUrl() : user.getHeadImg());
        userBaseInfoDTO.setForumNum(user.getPostNum());
        if (PlatformEnum.ANDROID.getCode() == platform) {
            userBaseInfoDTO.setPhone(user.getPhone());
        }
        userBaseInfoDTO.setSex(user.getSex());
        userBaseInfoDTO.setAttentionNum(user.getAttentionNum());
        userBaseInfoDTO.setFanNum(user.getFanNum());
        userBaseInfoDTO.setPersonalProfile(user.getPersonalProfile());
        userBaseInfoDTO.setAllInterviewNum(this.userVisitService.getInterviewNumByUserId(userId));
        userBaseInfoDTO.setInviteNum(user.getInviteNum());
        userBaseInfoDTO.setMaterialFinished(Boolean.valueOf(false));
        userBaseInfoDTO.setUnReadFanNum(this.messageUserIntegrationService.getUnReadMessageNum(userId, MessageTypeEnum.ADD_FUNS));
        userBaseInfoDTO.setRedPoint(Boolean.valueOf(false));
        userBaseInfoDTO.setNoticeNum(Integer.valueOf(0));
        userBaseInfoDTO.setTodayInterviewNum(this.userVisitService.getTodayVisitorNum(userId));
        userBaseInfoDTO.setUserCashGoldDTO(this.userAccountService.getUserCashGold(userId));
        userBaseInfoDTO.setInviteUserHeadImgList(this.userInviteService.getLastInviteUserHeadImgList(userId));
        this.setUserVip(userBaseInfoDTO, userId);
        userBaseInfoDTO.setOrderPrivacy(Boolean.valueOf(Objects.isNull(user.getJudgeMarker()) || !BitOperatorUtil.getBitAsBoolean((Long)user.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.ORDER_PRIVACY.getIndex())));
        return userBaseInfoDTO;
    }

    @Override
    public int countRegUser(String startTime, String endTime) {
        return this.userStatisticsMapper.countRegUser(startTime, endTime);
    }

    @Override
    public Boolean postUserPositionAndLoginInfo(UserLocationParam userLocationParam) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u4e0a\u62a5\u7528\u6237\u5b9a\u4f4d\u4ee5\u53ca\u6d3b\u8dc3\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)userLocationParam));
        }
        LocationDTO locationByGeocode = this.locationIntegrationService.getLocationByGeocode(userLocationParam.getAreaCode());
        UserActionEvent userActionEvent = ActiveActionEvent.of().setLastLoginTime(new Date()).setLongitude(userLocationParam.getLongitude()).setLatitude(userLocationParam.getLatitude()).setCurrentAreaCode(locationByGeocode.getCode()).setUserId(userLocationParam.getUserId());
        this.userActionEventBus.post((Object)userActionEvent);
        return true;
    }

    private void setUserVip(UserBaseInfoDTO userBaseInfoDTO, Long userId) {
        UserVip userVip = this.userVipService.getUserVipByUid(userId);
        boolean activeVip = userVip.getUsable();
        userBaseInfoDTO.setIsVip(Integer.valueOf(this.userVipService.isVip(userId) != false ? 1 : 0));
        if (activeVip) {
            userBaseInfoDTO.setCardNo(userVip.getCard());
            userBaseInfoDTO.setActiveCode(userVip.getActiveCode());
            userBaseInfoDTO.setEndDate(DateUtils.formatDate((Date)userVip.getExpiredDate()));
            userBaseInfoDTO.setLeftOpenNum(userVip.getLeftOpenNum());
        }
        MerchantUserDTO merchantUserDTO = this.merchantRelationService.getRelationMerchant(userId);
        userBaseInfoDTO.setMerchantStatus(Integer.valueOf(0));
        if (Objects.nonNull(merchantUserDTO)) {
            BeanUtils.copyProperties((Object)merchantUserDTO, (Object)userBaseInfoDTO);
        }
    }

    @Autowired
    public UserInternalServiceImpl(UserAccountService userAccountService, UserMapper userMapper, UserProperties userProperties, RedisStringAdapter redisStringAdapter, UserLocationHistoryMapper userLocationHistoryMapper, LocationIntegrationService locationIntegrationService, AliyunOSSService aliyunOSSService, AliyunOssProperties aliyunOssProperties, BizConfigProperties bizConfigProperties, BizLogIntegrationService bizLogIntegrationService, UserNewsIntegrationService userNewsIntegrationService, AppVersionIntegrationService appVersionIntegrationService, UserParamCheckService userParamCheckService, UserService userService, UserVisitService userVisitService, UserStatisticsMapper userStatisticsMapper, EventBus userActionEventBus, MessageUserIntegrationService messageUserIntegrationService, UserInviteService userInviteService, UserVipService userVipService, MerchantRelationService merchantRelationService) {
        this.userAccountService = userAccountService;
        this.userMapper = userMapper;
        this.userProperties = userProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.userLocationHistoryMapper = userLocationHistoryMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.aliyunOSSService = aliyunOSSService;
        this.aliyunOssProperties = aliyunOssProperties;
        this.bizConfigProperties = bizConfigProperties;
        this.bizLogIntegrationService = bizLogIntegrationService;
        this.userNewsIntegrationService = userNewsIntegrationService;
        this.appVersionIntegrationService = appVersionIntegrationService;
        this.userParamCheckService = userParamCheckService;
        this.userService = userService;
        this.userVisitService = userVisitService;
        this.userStatisticsMapper = userStatisticsMapper;
        this.userActionEventBus = userActionEventBus;
        this.messageUserIntegrationService = messageUserIntegrationService;
        this.userInviteService = userInviteService;
        this.userVipService = userVipService;
        this.merchantRelationService = merchantRelationService;
    }
}

