/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.support.impl;

import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserCountMapper;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.event.LocationActionEvent;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.model.dto.UserInviteRankDTO;
import com.bxm.localnews.user.model.dto.UserSaveCashDTO;
import com.bxm.localnews.user.properties.UserProperties;
import com.bxm.localnews.user.support.UserRankService;
import com.bxm.localnews.user.vo.Tuple;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.stereotype.Service;

@Service
public class UserRankServiceImpl
implements UserRankService {
    private final UserCountMapper userCountMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final RedisZSetAdapter redisZSetAdapter;
    private UserAccountService userAccountService;
    private final UserService userService;
    private final UserProperties userProperties;
    private static final int LIMIT = 500;

    @Autowired
    public UserRankServiceImpl(UserCountMapper userCountMapper, RedisHashMapAdapter redisHashMapAdapter, RedisZSetAdapter redisZSetAdapter, UserService userService, UserProperties userProperties) {
        this.userCountMapper = userCountMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisZSetAdapter = redisZSetAdapter;
        this.userService = userService;
        this.userProperties = userProperties;
    }

    private UserAccountService getUserAccountService() {
        if (this.userAccountService == null) {
            this.userAccountService = (UserAccountService)SpringContextHolder.getBean(UserAccountService.class);
        }
        return this.userAccountService;
    }

    @Override
    public Long getTotal(String areaCode) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return 0L;
        }
        Long total = (Long)this.redisHashMapAdapter.get(RedisConfig.USER_TOTAL_CACHE, areaCode, Long.class);
        if (total == null) {
            total = 0L;
        }
        return total;
    }

    @Override
    public Long getVipTotal(String areaCode) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return 0L;
        }
        Long total = (Long)this.redisHashMapAdapter.get(RedisConfig.USER_TOTAL_VIP_CACHE, areaCode, Long.class);
        if (total == null) {
            total = 0L;
        }
        total = total * (long)this.userProperties.getVirtualMultiple().intValue() + (long)this.userProperties.getVirtualTotalBase().intValue();
        return total;
    }

    private KeyGenerator buildKey(String areaCode) {
        return RedisConfig.AREA_REBATE_RANK_CACHE.copy().appendKey((Object)areaCode);
    }

    @Override
    public Long getSaveCashRank(Long userId, String areaCode) {
        Double score;
        KeyGenerator key = this.buildKey(areaCode);
        Long rank = this.redisZSetAdapter.reverseRank(key, (Object)userId);
        if (rank == null) {
            UserAccountDTO userAccount = this.getUserAccountService().getUserAccount(userId);
            BigDecimal saveCash = userAccount.getSaveCash();
            if (saveCash == null) {
                saveCash = BigDecimal.ZERO;
            } else {
                this.redisZSetAdapter.add(key, (Object)userId, saveCash.doubleValue());
            }
            if (BigDecimal.ZERO.equals(saveCash)) {
                rank = 0L;
            }
        } else {
            rank = rank + 1L;
        }
        if (!Objects.equals(rank, 0L) && ((score = this.redisZSetAdapter.score(key, (Object)userId)) == null || Objects.equals(score, 0.0))) {
            rank = 0L;
        }
        return rank;
    }

    @Override
    public Long getInviteNumRank(Long userId, String areaCode) {
        KeyGenerator rankKey = this.buildInviteRankKey(areaCode);
        Long rank = this.redisZSetAdapter.reverseRank(rankKey, (Object)userId);
        if (rank == null) {
            UserInfoDTO userCache = this.userService.getUserCache(userId);
            if (userCache.getInviteNum() != null && userCache.getInviteNum() > 0) {
                this.redisZSetAdapter.add(rankKey, (Object)userId, Double.valueOf(userCache.getInviteNum().intValue()).doubleValue());
            } else {
                rank = 0L;
            }
        } else {
            rank = rank + 1L;
        }
        return rank;
    }

    @EventListener
    public void changeLocation(LocationActionEvent event) {
        this.moveRank(event.getUserId(), event.getOldLocationCode(), event.getLocationCode());
    }

    @Override
    public void moveRank(Long userId, String sourceAreaCode, String targetAreaCode) {
        this.redisZSetAdapter.remove(this.buildKey(targetAreaCode), new Object[]{userId});
        this.redisZSetAdapter.remove(this.buildKey(sourceAreaCode), new Object[]{userId});
        this.getSaveCashRank(userId, targetAreaCode);
        this.redisZSetAdapter.remove(this.buildInviteRankKey(targetAreaCode), new Object[]{userId});
        this.redisZSetAdapter.remove(this.buildInviteRankKey(sourceAreaCode), new Object[]{userId});
        this.getInviteNumRank(userId, targetAreaCode);
    }

    @Override
    public void reloadUserSaveCashRank(Long userId) {
        UserInfoDTO userCache = this.userService.getUserCache(userId);
        if (Objects.nonNull(userCache.getLocationCode())) {
            this.redisZSetAdapter.remove(this.buildKey(userCache.getLocationCode()), new Object[]{userId});
            this.getSaveCashRank(userId, userCache.getLocationCode());
        }
    }

    @Override
    public void execInitCache() {
        List userVipRankList;
        List userRankList = this.userCountMapper.queryUserTotal();
        if (CollectionUtils.isNotEmpty((Collection)userRankList)) {
            Map<String, Integer> userRankMap = userRankList.stream().collect(Collectors.toMap(Tuple::getLabel, Tuple::getTotal));
            this.redisHashMapAdapter.putAll(RedisConfig.USER_TOTAL_CACHE, userRankMap);
        }
        if (CollectionUtils.isNotEmpty((Collection)(userVipRankList = this.userCountMapper.queryVipTotal()))) {
            Map<String, Integer> userRankMap = userVipRankList.stream().collect(Collectors.toMap(Tuple::getLabel, Tuple::getTotal));
            this.redisHashMapAdapter.putAll(RedisConfig.USER_TOTAL_VIP_CACHE, userRankMap);
        }
    }

    @Override
    public void refreshInviteRank() {
        Date date = DateUtils.addField((Date)new Date(), (int)12, (int)-60);
        this.loadInviteRank(0, date);
    }

    private void loadInviteRank(int startNum, Date modifyDate) {
        List inviteRanks = this.userCountMapper.queryInviteByPage(Integer.valueOf(startNum), Integer.valueOf(500), modifyDate);
        HashMap areaMap = Maps.newHashMap();
        for (UserInviteRankDTO userInviteRank : inviteRanks) {
            Set tuples2 = areaMap.getOrDefault(userInviteRank.getLocationCode(), Sets.newHashSet());
            if (userInviteRank.getInviteNum() != null) {
                tuples2.add(new DefaultTypedTuple((Object)userInviteRank.getUserId(), Double.valueOf(userInviteRank.getInviteNum().intValue())));
            }
            areaMap.put(userInviteRank.getLocationCode(), tuples2);
        }
        if (areaMap.size() > 0) {
            areaMap.forEach((areaCode, tuples) -> this.redisZSetAdapter.add(this.buildInviteRankKey((String)areaCode), tuples));
            if (inviteRanks.size() > 0 && inviteRanks.size() == 500) {
                this.loadInviteRank(startNum += 500, modifyDate);
            }
        }
    }

    private KeyGenerator buildInviteRankKey(String areaCode) {
        return RedisConfig.AREA_INVITE_RANK_CACHE.copy().appendKey((Object)areaCode);
    }

    @Override
    public void refreshSaveCashRank() {
        for (int i = 0; i < 10; ++i) {
            int startNum = 0;
            this.loadSaveCash(i, startNum);
        }
    }

    private void loadSaveCash(int tableIndex, int startNum) {
        List saveCashList = this.userCountMapper.querySaveCashByPage(Integer.valueOf(tableIndex), Integer.valueOf(startNum), Integer.valueOf(500));
        HashMap areaMap = Maps.newHashMap();
        for (UserSaveCashDTO userSaveCashDTO : saveCashList) {
            Set tuples2 = areaMap.getOrDefault(userSaveCashDTO.getLocationCode(), Sets.newHashSet());
            if (userSaveCashDTO.getSaveCash() != null) {
                tuples2.add(new DefaultTypedTuple((Object)userSaveCashDTO.getUserId(), userSaveCashDTO.getSaveCash()));
            }
            areaMap.put(userSaveCashDTO.getLocationCode(), tuples2);
        }
        if (areaMap.size() > 0) {
            areaMap.forEach((areaCode, tuples) -> this.redisZSetAdapter.add(this.buildKey((String)areaCode), tuples));
            if (saveCashList.size() > 0 && saveCashList.size() == 500) {
                this.loadSaveCash(tableIndex, startNum += 500);
            }
        }
    }
}

