/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.support.saf;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.saf.model.v20180919.ExecuteRequestRequest;
import com.aliyuncs.saf.model.v20180919.ExecuteRequestResponse;
import com.bxm.localnews.user.domain.RiskRecordMapper;
import com.bxm.localnews.user.param.RiskParam;
import com.bxm.localnews.user.vo.RiskRecord;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifyRiskSaf {
    private static final Logger log = LoggerFactory.getLogger(IdentifyRiskSaf.class);
    private static final String ACESSKEY_ID = "LTAIfYrWiI3zpHqX";
    private static final String SECRET_KEY = "3Lmcjh6gWLraAgAlGlHiS2UpM4Vq2i";
    private static final String PRODUCT = "saf";
    private static final String REGION_ID = "cn-hangzhou";
    private static final String DOMAIN = ".aliyuncs.com";
    private static final String SERVICE = "account_abuse_pro";

    public static void main(String[] args) {
    }

    private static IAcsClient getClient() {
        DefaultProfile profile = DefaultProfile.getProfile((String)REGION_ID, (String)ACESSKEY_ID, (String)SECRET_KEY);
        DefaultProfile.addEndpoint((String)REGION_ID, (String)PRODUCT, (String)IdentifyRiskSaf.getDomain());
        return new DefaultAcsClient((IClientProfile)profile);
    }

    private static String getDomain() {
        return "saf.cn-hangzhou.aliyuncs.com";
    }

    private static ExecuteRequestRequest getRequest() {
        ExecuteRequestRequest executeRequestRequest = new ExecuteRequestRequest();
        executeRequestRequest.setMethod(MethodType.POST);
        executeRequestRequest.setService(SERVICE);
        return executeRequestRequest;
    }

    public static ExecuteRequestResponse identifyRisk(String mobile, String deviceToken, String ip) {
        HashMap serviceParams = Maps.newHashMap();
        serviceParams.put("mobile", mobile);
        serviceParams.put("operateTime", DateUtils.getCurSeconds());
        serviceParams.put("deviceToken", deviceToken);
        serviceParams.put("ip", ip);
        ExecuteRequestRequest executeRequestRequest = IdentifyRiskSaf.getRequest();
        executeRequestRequest.setReadTimeout(Integer.valueOf(12000));
        executeRequestRequest.setServiceParameters(JSONObject.toJSONString((Object)serviceParams));
        try {
            executeRequestRequest.setHttpContent(JSONObject.toJSONString((Object)serviceParams).getBytes("UTF-8"), "UTF-8", FormatType.JSON);
            ExecuteRequestResponse httpResponse = (ExecuteRequestResponse)IdentifyRiskSaf.getClient().getAcsResponse((AcsRequest)executeRequestRequest);
            log.info("httpResponse:" + JSONObject.toJSONString((Object)httpResponse));
            return httpResponse;
        }
        catch (UnsupportedEncodingException unsupportException) {
            log.error("\u98ce\u9669\u8bc6\u522b\uff1ajson\u6570\u636e\u8f6c\u6362\u5931\u8d25");
        }
        catch (ClientException clientException) {
            log.error("\u8fde\u63a5\u963f\u91cc\u98ce\u9669\u8bc6\u522b\u5ba2\u6237\u7aef\u5931\u8d25");
        }
        return null;
    }

    private void addRiskRecord(RiskParam riskParam, ExecuteRequestResponse executeRequestResponse, Boolean isBlack, RiskRecordMapper mapper) {
        RiskRecord riskRecord = new RiskRecord();
        riskRecord.setId(Long.valueOf(riskParam.getId()));
        riskRecord.setPhone(riskParam.getPhone());
        riskRecord.setDeviceToken(riskParam.getEquiment());
        riskRecord.setOperateSystem(riskParam.getOperateSystem());
        riskRecord.setOperateSource(riskParam.getOperateSource());
        riskRecord.setScore(executeRequestResponse.getData().getScore());
        riskRecord.setTags(executeRequestResponse.getData().getTags());
        riskRecord.setRemark(executeRequestResponse.getData().getExtend());
        riskRecord.setReqIp(riskParam.getIp());
        riskRecord.setBlack(Byte.valueOf(isBlack != false ? (byte)1 : 0));
        mapper.addRiskRecord(riskRecord);
    }

    private boolean isRisk(BigDecimal score) {
        return BigDecimal.valueOf(65L).compareTo(score) < 0;
    }

    public boolean checkRiskDevice(RiskParam riskParam, RiskRecordMapper mapper) {
        ExecuteRequestResponse executeRequestResponse = IdentifyRiskSaf.identifyRisk(riskParam.getPhone(), riskParam.getDeviceToken(), riskParam.getIp());
        if (null != executeRequestResponse && 200 == executeRequestResponse.getCode()) {
            BigDecimal score = new BigDecimal(executeRequestResponse.getData().getScore());
            log.info("\u5f53\u524d\u8bbe\u5907\u624b\u673a\u53f7[{}]\u98ce\u9669\u7cfb\u6570\u4e3a[{}]", (Object)riskParam.getPhone(), (Object)score);
            boolean isRisk = this.isRisk(score);
            this.addRiskRecord(riskParam, executeRequestResponse, isRisk, mapper);
            return isRisk;
        }
        log.info("\u5f53\u524d\u8bbe\u5907\u624b\u673a\u53f7\uff1a[{}]\uff0c\u8bbe\u5907token:[{}], ip:[{}]\u6ca1\u80fd\u591f\u98ce\u9669\u8bc6\u522b", new Object[]{riskParam.getPhone(), riskParam.getDeviceToken(), riskParam.getIp()});
        return false;
    }
}

