/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.tbk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.tbk.factory.TaobaoClientFactory;
import com.bxm.localnews.user.domain.UserBindHistoryMapper;
import com.bxm.localnews.user.dto.RelationInfoRspDTO;
import com.bxm.localnews.user.dto.UserBindHistory;
import com.bxm.localnews.user.dto.UserTbkInfo;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.model.TbOpenBindRes;
import com.bxm.localnews.user.properties.TbOpenOrderProperties;
import com.bxm.localnews.user.tbk.UserTbkBindService;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.enums.AppNameEnum;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.TbkScPublisherInfoSaveRequest;
import com.taobao.api.request.TopAuthTokenCreateRequest;
import com.taobao.api.response.TbkScPublisherInfoSaveResponse;
import com.taobao.api.response.TopAuthTokenCreateResponse;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserTbkBindServiceImpl
implements UserTbkBindService {
    private static final Logger log = LoggerFactory.getLogger(UserTbkBindServiceImpl.class);
    @Autowired
    private TbOpenOrderProperties tbOpenOrderProperties;
    @Autowired
    private TaobaoClientFactory taobaoClientFactory;
    @Autowired
    private UserService userService;
    @Autowired
    private UserBindHistoryMapper userBindHistoryMapper;
    @Autowired
    private SequenceCreater sequenceCreater;

    @Override
    public RelationInfoRspDTO relateUserInfo(Long userId, String code) {
        log.info("\u7ed1\u5b9a\u6dd8\u5b9d\u8bf7\u6c42\u53c2\u6570: userId: {} code: {}", (Object)userId, (Object)code);
        RelationInfoRspDTO result = new RelationInfoRspDTO();
        if (Objects.isNull(userId) || StringUtils.isBlank((String)code)) {
            result.setOk(false);
            result.setDesc("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
            return result;
        }
        TbOpenBindRes res = this.getTbToken(code);
        if (StringUtils.isBlank((String)res.getAccessToken())) {
            result.setOk(false);
            result.setDesc(res.getErrorMsg());
            this.createBindHistory(userId, res.getSourceRes(), 0);
            return result;
        }
        String accessToken = res.getAccessToken();
        if (StringUtils.isBlank((String)(res = this.getBindIdByTokenAndType(accessToken, 1)).getRelationId())) {
            log.warn("\u6dd8\u5b9d\u7ed1\u5b9a\u5931\u8d25\uff0c\u6dd8\u5b9dAPI\u8fd4\u56derelation id \u4fe1\u606f\u4e3a\u7a7a, userId:{}, code:{} errMsg: {}", new Object[]{userId, code, res.getErrorMsg()});
            result.setOk(false);
            result.setDesc(res.getErrorMsg());
            this.createBindHistory(userId, res.getSourceRes(), 0);
            return result;
        }
        String relationId = res.getRelationId();
        UserTbkInfo info = this.userService.selectUserFromCacheByRelationId(relationId);
        if (Objects.nonNull(info)) {
            if (!Objects.equals(info.getId(), userId)) {
                log.warn("\u6dd8\u5b9d\u7ed1\u5b9a\u5931\u8d25\uff0c\u91cd\u590d\u8fdb\u884c\u7ed1\u5b9a, userId:{}, code:{}", (Object)userId, (Object)code);
                result.setOk(false);
                result.setRelationId(relationId);
                result.setDesc("\u5f53\u524d\u8d26\u53f7\u5df2\u7ed1\u5b9a\u7528\u6237: " + info.getNickname());
                return result;
            }
            log.warn("\u6dd8\u5b9d\u7ed1\u5b9a\u6210\u529f\uff0c\u4f46\u8fdb\u884c\u4e86\u91cd\u590d\u7ed1\u5b9a, userId: {}, code: {}", (Object)userId, (Object)code);
            result.setOk(true);
            result.setRelationId(relationId);
            result.setDesc("\u7ed1\u5b9a\u6210\u529f");
            return result;
        }
        res = this.getBindIdByTokenAndType(accessToken, 2);
        if (StringUtils.isBlank((String)res.getSpecialId())) {
            log.warn("\u6dd8\u5b9d\u7ed1\u5b9a\u5931\u8d25\uff0c\u6dd8\u5b9dAPI\u8fd4\u56despecial id \u4fe1\u606f\u4e3a\u7a7a, userId:{}, code:{} errMsg: {}", new Object[]{userId, code, res.getErrorMsg()});
            result.setOk(false);
            result.setDesc(res.getErrorMsg());
            this.createBindHistory(userId, res.getSourceRes(), 0);
            return result;
        }
        this.userService.updateTbkInfo(userId, relationId, res.getSpecialId());
        this.createBindHistory(userId, res.getSourceRes(), 1);
        result.setOk(true);
        result.setRelationId(relationId);
        result.setDesc("\u7ed1\u5b9a\u6210\u529f");
        return result;
    }

    private void createBindHistory(Long userId, String result, Integer bindResult) {
        UserBindHistory bindHistory = new UserBindHistory();
        bindHistory.setId(this.sequenceCreater.nextLongId());
        bindHistory.setUserId(userId);
        bindHistory.setPlatform("\u6dd8\u5b9d\u8054\u76df");
        bindHistory.setNickname("");
        bindHistory.setHeadImg("");
        bindHistory.setBindResult(bindResult);
        bindHistory.setSource(result);
        bindHistory.setCreateTime(new Date());
        this.userBindHistoryMapper.insertSelective(bindHistory);
    }

    private TbOpenBindRes getBindIdByTokenAndType(String accessToken, int type) {
        TbOpenBindRes res = TbOpenBindRes.builder().build();
        String sourceRes = "";
        try {
            TbkScPublisherInfoSaveRequest req = new TbkScPublisherInfoSaveRequest();
            req.setOfflineScene("4");
            req.setOnlineScene("3");
            if (type == 1) {
                req.setInviterCode(this.tbOpenOrderProperties.getRelationInviteCode());
            } else {
                req.setInviterCode(this.tbOpenOrderProperties.getSpecialInviteCode());
            }
            req.setInfoType(Long.valueOf(1L));
            req.setNote("\u5176\u4ed6");
            if (log.isDebugEnabled()) {
                log.debug("\u7ed1\u5b9a\u6e20\u9053\u5173\u7cfb\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)req));
            }
            TbkScPublisherInfoSaveResponse resp = (TbkScPublisherInfoSaveResponse)this.taobaoClientFactory.getClient(AppNameEnum.LOCAL_NEWS.name()).execute((TaobaoRequest)req, accessToken);
            sourceRes = JSON.toJSONString((Object)resp);
            if (log.isDebugEnabled()) {
                log.debug("\u7ed1\u5b9a\u6e20\u9053\u5173\u7cfb\u8fd4\u56de\u53c2\u6570: {}", (Object)sourceRes);
            }
            if (Objects.isNull(resp)) {
                return TbOpenBindRes.builder().errorMsg("\u7ed1\u5b9a\u6e20\u9053\u5173\u7cfb\u5931\u8d25").sourceRes(sourceRes).build();
            }
            if (Objects.isNull(resp.getData())) {
                return TbOpenBindRes.builder().errorMsg(resp.getSubMsg()).sourceRes(sourceRes).build();
            }
            res = TbOpenBindRes.builder().relationId(Objects.toString(resp.getData().getRelationId())).specialId(Objects.toString(resp.getData().getSpecialId())).sourceRes(sourceRes).build();
        }
        catch (Exception e) {
            log.error("\u7ed1\u5b9a\u6e20\u9053\u5173\u7cfb\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570: sessionKey: {} type: {}", new Object[]{accessToken, type, e});
        }
        log.info("\u6839\u636e accessToken: {} type: {} \u83b7\u53d6\u5230\u7684\u7ed1\u5b9a\u4fe1\u606f: {}", new Object[]{accessToken, type, JSON.toJSONString((Object)res)});
        return res;
    }

    private TbOpenBindRes getTbToken(String code) {
        String accessToken = "";
        String sourceRes = "";
        try {
            TopAuthTokenCreateRequest req = new TopAuthTokenCreateRequest();
            req.setCode(code);
            if (log.isDebugEnabled()) {
                log.debug("code\u6362\u53d6 access token \u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)req));
            }
            TopAuthTokenCreateResponse rsp = (TopAuthTokenCreateResponse)this.taobaoClientFactory.getClient(AppNameEnum.LOCAL_NEWS.name()).execute((TaobaoRequest)req);
            sourceRes = JSON.toJSONString((Object)rsp);
            if (log.isDebugEnabled()) {
                log.debug("code\u6362\u53d6 access token \u8fd4\u56de\u53c2\u6570: {}", (Object)sourceRes);
            }
            if (Objects.isNull(rsp)) {
                return TbOpenBindRes.builder().errorMsg("\u83b7\u53d6access token\u5931\u8d25").sourceRes(sourceRes).build();
            }
            if (!rsp.isSuccess() || StringUtils.isBlank((String)rsp.getTokenResult())) {
                return TbOpenBindRes.builder().errorMsg(rsp.getSubMsg()).sourceRes(sourceRes).build();
            }
            JSONObject token = JSON.parseObject((String)rsp.getTokenResult());
            if (Objects.isNull(token) || !token.containsKey((Object)"access_token")) {
                return TbOpenBindRes.builder().errorMsg("\u83b7\u53d6access token\u5931\u8d25").sourceRes(sourceRes).build();
            }
            accessToken = token.getString("access_token");
        }
        catch (Exception e) {
            log.error("code: {} \u6362\u53d6\u6dd8\u5b9dtoken\uff0c\u8bf7\u6c42\u6dd8\u5b9d\u63a5\u53e3\u5931\u8d25", (Object)code, (Object)e);
        }
        log.info("code: {} \u6362\u53d6\u6dd8\u5b9dtoken: {}", (Object)code, (Object)accessToken);
        return TbOpenBindRes.builder().accessToken(accessToken).sourceRes(sourceRes).build();
    }

    @Override
    public RelationInfoRspDTO checkRelation(Long userId) {
        RelationInfoRspDTO result = new RelationInfoRspDTO();
        User info = this.userService.selectByPrimaryKey(userId);
        if (Objects.isNull(userId) || Objects.isNull(info)) {
            result.setOk(false);
            result.setDesc("\u7528\u6237\u4e0d\u5b58\u5728");
            return result;
        }
        if (StringUtils.isNotBlank((String)info.getTbkRelationId())) {
            result.setOk(true);
            result.setRelationId(info.getTbkRelationId());
            result.setDesc("\u5df2\u7ed1\u5b9a");
        } else {
            result.setOk(false);
            result.setDesc("\u672a\u7ed1\u5b9a");
        }
        return result;
    }
}

