/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.timer;

import com.bxm.localnews.user.domain.UserInviteHistoryMapper;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.inner.IntervalMap;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserInvitePushTask
extends AbstractCronTask<String> {
    private final UserInviteHistoryMapper userInviteHistoryMapper;
    private final PushMsgIntegrationService pushMsgIntegrationService;
    private final UserService userService;

    @Autowired
    public UserInvitePushTask(UserInviteHistoryMapper userInviteHistoryMapper, PushMsgIntegrationService pushMsgIntegrationService, UserService userService) {
        this.userInviteHistoryMapper = userInviteHistoryMapper;
        this.pushMsgIntegrationService = pushMsgIntegrationService;
        this.userService = userService;
    }

    protected ReturnT<String> service(String param) {
        IntervalMap interval = DateUtils.getInterval((DateUtils.Interval)DateUtils.Interval.YESTERDAY);
        List collectByDate = this.userInviteHistoryMapper.getCollectByDate(interval.getStartTime(), interval.getEndTime());
        if (CollectionUtils.isNotEmpty((Collection)collectByDate)) {
            collectByDate.forEach(tuple -> {
                Long userId = Long.valueOf(tuple.getLabel());
                LocationUserInfoDTO location = this.userService.getLocationUserInfo(userId);
                this.pushMsgIntegrationService.pushUserInvite(userId, Integer.valueOf(tuple.getTotal()), location);
            });
        }
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "\u7528\u6237\u6536\u5f92\u7edf\u8ba1\u4fe1\u606f\u63a8\u9001";
    }

    public String cron() {
        return "0 0 8 * * ?";
    }
}

