/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.timer;

import com.bxm.localnews.user.domain.UserVipHistoryMapper;
import com.bxm.localnews.user.enums.ActivationVipStatusEnum;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vo.UserVip;
import com.bxm.localnews.user.vo.UserVipHistory;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserVipTimeoutTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(UserVipTimeoutTask.class);
    @Autowired
    private UserVipService userVipService;
    @Autowired
    private UserVipHistoryMapper userVipHistoryMapper;
    @Autowired
    private SequenceCreater sequenceCreater;

    protected ReturnT<String> service(String callbackParam) {
        List<UserVip> timeoutVipInfo = this.userVipService.getExpiredVipList(ActivationVipStatusEnum.USEFUL.getStatus(), new Date());
        if (timeoutVipInfo.size() > 0) {
            List<Long> userIds = timeoutVipInfo.stream().map(UserVip::getUserId).collect(Collectors.toList());
            this.userVipService.updateBatchStatusByUid(ActivationVipStatusEnum.TIMEOUT.getStatus(), userIds);
            for (UserVip userVip : timeoutVipInfo) {
                this.userVipService.removeCache(userVip.getUserId());
                UserVipHistory vipHistory = new UserVipHistory();
                vipHistory.setId(this.sequenceCreater.nextLongId());
                vipHistory.setOperation("VIP\u5230\u671f");
                vipHistory.setVipId(userVip.getId());
                vipHistory.setUserId(userVip.getUserId());
                this.userVipHistoryMapper.insertSelective(vipHistory);
            }
        }
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "USER_VIP_TIME_OUT_TASK";
    }

    public String cron() {
        return "5 0 0 * * ?";
    }

    public String description() {
        return "\u6bcf\u5929\u66f4\u65b0\u8fc7\u671f\u7684VIP\u7528\u6237";
    }
}

