/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.utils;

import com.bxm.newidea.component.tools.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Objects;

public class NumberConvertUtils {
    private static char[] CHAR_ARRAY = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZ".toCharArray();
    private static ThreadLocal<DecimalFormat> FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> {
        DecimalFormat decimalFormat = new DecimalFormat("##.##");
        decimalFormat.setRoundingMode(RoundingMode.DOWN);
        return decimalFormat;
    });
    private static Range[] SAVE_CACHE_RANGE_ARRAY = new Range[]{new Range(0, 1, 0.07f), new Range(1, 3, 0.12f), new Range(3, 5, 0.19f), new Range(5, 10, 0.28f), new Range(10, 20, 0.39f), new Range(20, 50, 0.45f), new Range(50, 100, 0.56f), new Range(100, 200, 0.69f), new Range(200, 300, 0.77f), new Range(300, 500, 0.83f), new Range(500, Integer.MAX_VALUE, 0.97f)};
    private static Range[] INVITE_NUM_RANGE_ARRAY = new Range[]{new Range(0, 1, 0.02f), new Range(1, 5, 0.05f), new Range(5, 10, 0.13f), new Range(10, 20, 0.29f), new Range(20, 50, 0.45f), new Range(50, 100, 0.56f), new Range(100, 200, 0.69f), new Range(200, 300, 0.77f), new Range(300, 500, 0.83f), new Range(500, Integer.MAX_VALUE, 0.97f)};

    private NumberConvertUtils() {
    }

    public static String convertToShortCode(Long num, Integer minLength) {
        StringBuilder res = new StringBuilder();
        int length = CHAR_ARRAY.length;
        while (num > 0L) {
            res.append(CHAR_ARRAY[(int)(num % (long)length)]);
            num = num / (long)length;
        }
        if (res.length() < minLength) {
            for (int i = 0; i < minLength - res.length(); ++i) {
                res.append("0");
            }
        }
        return StringUtils.reverse((String)res.toString());
    }

    public static String formatNum(Long value) {
        if (value == null) {
            return "0";
        }
        if (value < 10000L) {
            return value.toString();
        }
        float num = (float)value.longValue() / 10000.0f;
        return FORMAT_THREAD_LOCAL.get().format(num) + "\u4e07";
    }

    public static String formatSaveCashPercent(Long numerator, Long denominator, BigDecimal saveCash) {
        if (saveCash == null) {
            saveCash = BigDecimal.ZERO;
        }
        float offPercent = 1.0f;
        for (Range range : SAVE_CACHE_RANGE_ARRAY) {
            if (!(saveCash.floatValue() <= (float)range.right)) continue;
            offPercent = range.percent;
            break;
        }
        return NumberConvertUtils.formatPercent(numerator, denominator, offPercent);
    }

    public static String formatInvitePercent(Long numerator, Long denominator, Long inviteNums) {
        if (inviteNums == null) {
            inviteNums = 0L;
        }
        float offPercent = 1.0f;
        if (numerator > 20L) {
            for (Range range : INVITE_NUM_RANGE_ARRAY) {
                if (inviteNums > (long)range.right) continue;
                offPercent = range.percent;
                break;
            }
        }
        return NumberConvertUtils.formatPercent(numerator, denominator, offPercent);
    }

    private static String formatPercent(Long numerator, Long denominator, float offPercent) {
        if (numerator == null || denominator == null || Objects.equals(denominator, 0L) || Objects.equals(numerator, 0L)) {
            return "0%";
        }
        float percent = ((float)denominator.longValue() - (float)numerator.longValue()) / (float)denominator.longValue() * 100.0f * offPercent;
        return FORMAT_THREAD_LOCAL.get().format(percent) + "%";
    }

    private static class Range {
        int left;
        int right;
        float percent;

        Range(int left, int right, float percent) {
            this.left = left;
            this.right = right;
            this.percent = percent;
        }
    }
}

