/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.vip.activation;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.domain.vip.UserActiveRelationMapper;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.enums.ActivationVipEnum;
import com.bxm.localnews.user.integration.BizLogIntegrationService;
import com.bxm.localnews.user.integration.PushMsgIntegrationService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.ActivationUserVipParam;
import com.bxm.localnews.user.vip.ActiveCodeService;
import com.bxm.localnews.user.vip.activation.AbstractActivationVipStrategy;
import com.bxm.localnews.user.vo.UserVip;
import com.bxm.localnews.user.vo.vip.UserActiveCodeBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.time.LocalDate;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class CodeActivationStrategy
extends AbstractActivationVipStrategy {
    private static final Logger log = LoggerFactory.getLogger(CodeActivationStrategy.class);
    private final PushMsgIntegrationService pushMsgIntegrationService;
    private final UserService userService;
    private final BizLogIntegrationService bizLogIntegrationService;
    private final ActiveCodeService activeCodeService;
    private final UserActiveRelationMapper userActiveRelationMapper;
    private Pattern pattern = Pattern.compile("[0-9a-zA-Z]{1,}");

    @Autowired
    public CodeActivationStrategy(PushMsgIntegrationService pushMsgIntegrationService, UserService userService, BizLogIntegrationService bizLogIntegrationService, ActiveCodeService activeCodeService, UserActiveRelationMapper userActiveRelationMapper) {
        this.pushMsgIntegrationService = pushMsgIntegrationService;
        this.userService = userService;
        this.bizLogIntegrationService = bizLogIntegrationService;
        this.activeCodeService = activeCodeService;
        this.userActiveRelationMapper = userActiveRelationMapper;
    }

    @Override
    public Message preCheck(ActivationUserVipParam param) {
        if (!this.pattern.matcher(param.getCode()).matches()) {
            log.info("\u8f93\u5165\u7684\u6fc0\u6d3b\u7801\u683c\u5f0f\u9519\u8bef\uff0c\u6fc0\u6d3b\u7801\u4e3a\uff1a[{}]", (Object)param.getCode());
            return Message.build((boolean)false, (String)"\u6fc0\u6d3b\u7801\u683c\u5f0f\u9519\u8bef").addParam("ak", (Object)0);
        }
        UserActiveCodeBean activeCodeInfo = this.activeCodeService.getUsableActiveCode(param.getCode());
        if (null == activeCodeInfo) {
            log.info("\u7528\u6237\u8f93\u5165\u7684\u6fc0\u6d3b\u7801\u4e0d\u5b58\u5728\uff0c\u6fc0\u6d3b\u7801\u4e3a\uff1a[{}]", (Object)param.getCode());
            return Message.build((boolean)false, (String)"\u6fc0\u6d3b\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u5931\u6548").addParam("ak", (Object)0);
        }
        if (null == activeCodeInfo.getMaxTimes() || activeCodeInfo.getMaxTimes() <= 0) {
            return Message.build((boolean)false, (String)"\u6fc0\u6d3b\u7801\u6b21\u6570\u5df2\u7528\u5b8c").addParam("ak", (Object)3);
        }
        UserVip openUserVip = this.getUserVipService().getUserVipByUid(param.getUserId());
        if (openUserVip.getUsable().booleanValue()) {
            log.info("{}\u5df2\u7ecf\u662fVIP,\u91cd\u590d\u8fdb\u884c\u4e86\u6fc0\u6d3b", (Object)param.getUserId());
            return Message.build((boolean)false, (String)"\u4f60\u5df2\u7ecf\u662fVIP,\u4e0d\u9700\u8981\u91cd\u590d\u6fc0\u6d3b.").addParam("ak", (Object)2);
        }
        Message message = this.activeCodeService.decrementWithRetry(param.getCode());
        if (message.isSuccess()) {
            param.setCodeUserId(activeCodeInfo.getUserId());
        } else {
            message.addParam("ak", (Object)3);
        }
        if (StringUtils.isBlank((CharSequence)param.getChannel())) {
            param.setChannel("CODE");
        }
        return message;
    }

    @Override
    protected void afterFailed(ActivationUserVipParam param) {
        this.activeCodeService.incrementWithRetry(param.getCode());
        this.userActiveRelationMapper.removeRelation(param.getCode(), param.getUserId());
    }

    @Override
    protected void afterSuccess(ActivationUserVipParam param) {
        if (null != param.getCodeUserId()) {
            PointReportParam reportParam = PointReportParam.build((BasicParam)param).e("3034").ev("119." + param.getCodeUserId()).put("uid", String.valueOf(param.getUserId()));
            if (param.getPlatformEnum() != null) {
                reportParam.dtype(param.getPlatformEnum().toString());
            }
            this.bizLogIntegrationService.point(reportParam);
            this.getUserVipService().removeCache(param.getCodeUserId());
        }
        if (null != param.getMasterId()) {
            LocationUserInfoDTO location = this.userService.getLocationUserInfo(param.getMasterId());
            if (location != null) {
                this.pushMsgIntegrationService.pushMasterReceiveMessage(param.getMasterId(), param.getUserName(), location);
            } else {
                log.error("\u7528\u6237[{}]\u65e0\u6240\u5c5e\u5730\u533a\u4fe1\u606f\uff0c\u4e0d\u53d1\u9001\u63a8\u9001", (Object)param.getMasterId());
            }
        }
    }

    @Override
    InviteTypeEnum getInviteType() {
        return InviteTypeEnum.ACTIVE_CODE;
    }

    @Override
    public ActivationVipEnum getType() {
        return ActivationVipEnum.ACTIVATION_CODE;
    }

    @Override
    int getDuration(ActivationUserVipParam param) {
        LocalDate current = LocalDate.now();
        LocalDate nextYear = LocalDate.now().plusYears(1L);
        return (int)(nextYear.toEpochDay() - current.toEpochDay());
    }
}

