/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.vip.code.impl;

import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.vip.ActiveCodeDTO;
import com.bxm.localnews.user.enums.ActiveCodeTypeEnum;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.vip.code.ActiveCodeProcessContext;
import com.bxm.localnews.user.vip.code.impl.AbstractCodeProcessStrategy;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubCodeProcessStrategy
extends AbstractCodeProcessStrategy {
    @Autowired
    private UserService userService;

    @Override
    public ActiveCodeDTO process(ActiveCodeProcessContext context) {
        String cardNo = null;
        String activeCode = this.getActiveCodeService().nextCode();
        UserInfoDTO user = this.userService.getUserCache(context.getUserId());
        if (StringUtils.isNotBlank((CharSequence)user.getLocationCode())) {
            cardNo = this.vipCardService.nextCard(user.getLocationCode());
            context.setUserAreaCode(user.getLocationCode());
        } else if (StringUtils.isNotBlank((CharSequence)context.getSourceCodeInfo().getAreaCode())) {
            cardNo = this.vipCardService.nextCard(context.getSourceCodeInfo().getAreaCode());
            context.setUserAreaCode(context.getSourceCodeInfo().getAreaCode());
        }
        context.setNewCardNo(cardNo);
        context.setNewActiveCode(activeCode);
        this.saveActiveRelation(context);
        this.saveActiveCodeRecord(context, ActiveCodeTypeEnum.SUB);
        return ActiveCodeDTO.builder().cardNo(cardNo).activeCode(activeCode).build();
    }

    @Override
    public ActiveCodeTypeEnum match() {
        return ActiveCodeTypeEnum.SUB;
    }
}

