/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.vip.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserMapper;
import com.bxm.localnews.user.domain.vip.UserActiveCodeMapper;
import com.bxm.localnews.user.domain.vip.UserActiveRelationMapper;
import com.bxm.localnews.user.dto.UserInviteBindDTO;
import com.bxm.localnews.user.dto.vip.ActiveCodeDTO;
import com.bxm.localnews.user.enums.ActivationVipEnum;
import com.bxm.localnews.user.enums.ActiveCodeTypeEnum;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.invite.UserInviteService;
import com.bxm.localnews.user.invite.bind.BindInviteManager;
import com.bxm.localnews.user.model.ResultDTO;
import com.bxm.localnews.user.param.ActivationUserVipParam;
import com.bxm.localnews.user.param.AddTimesParam;
import com.bxm.localnews.user.param.OfflineBindRelationParam;
import com.bxm.localnews.user.properties.UserVipProperties;
import com.bxm.localnews.user.utils.NumberConvertUtils;
import com.bxm.localnews.user.vip.ActiveCodeService;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vip.VipCardService;
import com.bxm.localnews.user.vip.activation.ActivationVipManager;
import com.bxm.localnews.user.vip.code.ActiveCodeProcessContext;
import com.bxm.localnews.user.vip.code.IActiveCodeProcessStrategy;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserInviteOrderVO;
import com.bxm.localnews.user.vo.vip.UserActiveCodeBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.RetryException;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActiveCodeServiceImpl
implements ActiveCodeService {
    private static final Logger log = LoggerFactory.getLogger(ActiveCodeServiceImpl.class);
    private Map<ActiveCodeTypeEnum, IActiveCodeProcessStrategy> strategyMap;
    private final UserActiveCodeMapper userActiveCodeMapper;
    private final UserActiveRelationMapper userActiveRelationMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final VipCardService vipCardService;
    private final SequenceCreater sequenceCreater;
    private final UserVipProperties userVipProperties;
    private final UserMapper userMapper;
    private static final Long START_NUM = 10000000L;
    private final UserInviteService userInviteService;
    private UserVipService userVipService;
    private final BindInviteManager bindInviteManager;
    private ActivationVipManager activationVipManager;

    @Autowired
    public ActiveCodeServiceImpl(List<IActiveCodeProcessStrategy> strategyList, UserActiveCodeMapper userActiveCodeMapper, UserActiveRelationMapper userActiveRelationMapper, RedisStringAdapter redisStringAdapter, VipCardService vipCardService, SequenceCreater sequenceCreater, UserVipProperties userVipProperties, UserMapper userMapper, UserInviteService userInviteService, BindInviteManager bindInviteManager) {
        this.userActiveCodeMapper = userActiveCodeMapper;
        this.userActiveRelationMapper = userActiveRelationMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.vipCardService = vipCardService;
        this.sequenceCreater = sequenceCreater;
        this.userVipProperties = userVipProperties;
        this.userMapper = userMapper;
        this.userInviteService = userInviteService;
        this.bindInviteManager = bindInviteManager;
        this.strategyMap = Maps.newHashMap();
        strategyList.forEach(strategy -> this.strategyMap.put(strategy.match(), (IActiveCodeProcessStrategy)strategy));
    }

    private UserVipService getUserVipService() {
        if (this.userVipService == null) {
            this.userVipService = (UserVipService)SpringContextHolder.getBean(UserVipService.class);
        }
        return this.userVipService;
    }

    private ActivationVipManager getActivationVipManager() {
        if (this.activationVipManager == null) {
            this.activationVipManager = (ActivationVipManager)SpringContextHolder.getBean(ActivationVipManager.class);
        }
        return this.activationVipManager;
    }

    @Override
    public UserActiveCodeBean getUsableActiveCode(String activeCode) {
        UserActiveCodeBean entity = this.userActiveCodeMapper.selectByCode(activeCode);
        if (null == entity) {
            return null;
        }
        return entity;
    }

    @Override
    public UserActiveCodeBean getActiveCode(String activeCode) {
        return this.userActiveCodeMapper.selectByCode(activeCode);
    }

    @Override
    @Retryable(value={RetryException.class})
    public Message decrementWithRetry(String activeCode) {
        UserActiveCodeBean currentActiveCode = this.userActiveCodeMapper.selectByCode(activeCode);
        if (currentActiveCode.getMaxTimes() <= 0) {
            return Message.build((boolean)false, (String)"\u6fc0\u6d3b\u7801\u65e0\u53ef\u7528\u6b21\u6570");
        }
        currentActiveCode.setMaxTimes(Integer.valueOf(currentActiveCode.getMaxTimes() - 1));
        currentActiveCode.setActiveTimes(Integer.valueOf(currentActiveCode.getActiveTimes() + 1));
        if (currentActiveCode.getMaxTimes() <= 0) {
            currentActiveCode.setStatus(AppConst.DISALBE);
        } else {
            currentActiveCode.setStatus(AppConst.ENABLE);
        }
        int result = this.userActiveCodeMapper.updateTimes(currentActiveCode);
        if (result == 0) {
            log.error("\u6fc0\u6d3b\u7801\u6263\u9664\u5931\u8d25\uff0c\u6fc0\u6d3b\u7801\u4e3a\uff1a{}", (Object)activeCode);
            throw new RetryException("\u6263\u9664\u6fc0\u6d3b\u7801\u53ef\u7528\u6b21\u6570\u66f4\u65b0\u5931\u8d25\uff0c\u91cd\u8bd5");
        }
        return Message.build((int)result);
    }

    @Override
    @Retryable(value={RetryException.class})
    public Message incrementWithRetry(String activeCode) {
        int result;
        UserActiveCodeBean currentActiveCode = this.userActiveCodeMapper.selectByCode(activeCode);
        currentActiveCode.setStatus(AppConst.ENABLE);
        currentActiveCode.setMaxTimes(Integer.valueOf(currentActiveCode.getMaxTimes() + 1));
        if (currentActiveCode.getMaxTimes() <= 0) {
            currentActiveCode.setMaxTimes(Integer.valueOf(1));
        }
        if (currentActiveCode.getActiveTimes() > 0) {
            currentActiveCode.setActiveTimes(Integer.valueOf(currentActiveCode.getActiveTimes() - 1));
        }
        if ((result = this.userActiveCodeMapper.updateTimes(currentActiveCode)) == 0) {
            log.error("\u6fc0\u6d3b\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u6fc0\u6d3b\u7801\u4e3a\uff1a{}", (Object)activeCode);
            throw new RetryException("\u589e\u52a0\u6fc0\u6d3b\u7801\u53ef\u7528\u6b21\u6570\u66f4\u65b0\u5931\u8d25\uff0c\u91cd\u8bd5");
        }
        return Message.build((int)result);
    }

    @Override
    public Message addActiveTimes(AddTimesParam param) {
        UserActiveCodeBean activeCode;
        Boolean vip = this.getUserVipService().isVip(param.getUserId());
        if (Boolean.FALSE.equals(vip)) {
            log.info("\u7528\u6237[{}]\u4e0d\u662fVIP\uff0c\u6dfb\u52a0\u6fc0\u6d3b\u7801\u65f6\uff0c\u624b\u5de5\u6fc0\u6d3bVIP", (Object)param.getUserId());
            ActivationUserVipParam vipParam = new ActivationUserVipParam();
            vipParam.setUserId(param.getUserId());
            vipParam.setActivationVipEnum(ActivationVipEnum.MANUAL);
            Message message = this.getActivationVipManager().activationVip(vipParam);
            if (Boolean.FALSE.equals(message.isSuccess())) {
                return message;
            }
        }
        if (null == (activeCode = this.userActiveCodeMapper.selectByUserId(param.getUserId()))) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u672a\u5f00\u901aVIP\u6216\u65e0\u6fc0\u6d3b\u7801");
        }
        if (param.getTimes() <= 0 && param.getTimes() > 99999) {
            return Message.build((boolean)false, (String)"\u6fc0\u6d3b\u7801\u8bbe\u7f6e\u8303\u56f4\u8d85\u8fc7\u9650\u5236\u8303\u56f4");
        }
        activeCode.setMaxTimes(param.getTimes());
        activeCode.setStatus(AppConst.ENABLE);
        int total = this.userActiveCodeMapper.addTimes(activeCode);
        if (total > 0) {
            this.getUserVipService().removeCache(param.getUserId());
        }
        return Message.build((int)total);
    }

    @Override
    public ActiveCodeDTO process(ActiveCodeProcessContext context) {
        if (ActivationVipEnum.PAY.equals((Object)context.getActivationVipType())) {
            context.setActiveCodeType(ActiveCodeTypeEnum.PAYMENT);
        } else if (StringUtils.isNotBlank((String)context.getCode())) {
            UserActiveCodeBean sourceCodeInfo = this.getActiveCode(context.getCode());
            context.setSourceCodeInfo(sourceCodeInfo);
            if (Objects.equals(ActiveCodeTypeEnum.CHANNEL.getCode(), sourceCodeInfo.getCardType())) {
                context.setActiveCodeType(ActiveCodeTypeEnum.CHANNEL);
            } else {
                context.setActiveCodeType(ActiveCodeTypeEnum.SUB);
            }
        } else {
            context.setActiveCodeType(ActiveCodeTypeEnum.MANUAL);
        }
        return this.strategyMap.get(context.getActiveCodeType()).process(context);
    }

    @Override
    public String nextCode() {
        return this.nextCode(1).get(0);
    }

    @Override
    public List<String> nextCode(Integer limit) {
        int randomKey = RandomUtils.nextInt((int)1, (int)21);
        KeyGenerator key = RedisConfig.VIP_CODE_KEY.copy().appendKey((Object)randomKey);
        if (!this.redisStringAdapter.hasKey(key).booleanValue()) {
            this.redisStringAdapter.set(key, START_NUM * (long)randomKey);
        }
        long afterIncrementNum = this.redisStringAdapter.increment(key, limit.intValue());
        ArrayList<String> codeList = new ArrayList<String>(limit);
        for (int i = limit - 1; i >= 0; --i) {
            codeList.add(NumberConvertUtils.convertToShortCode(afterIncrementNum - (long)i, 6));
        }
        return codeList;
    }

    @Override
    public List<ActiveCodeDTO> execBatchExport(String areaCode, int limit) {
        List<String> cardNoList = this.vipCardService.nextCard(areaCode, limit);
        ArrayList<ActiveCodeDTO> result = new ArrayList<ActiveCodeDTO>(limit);
        ArrayList<UserActiveCodeBean> saveList = new ArrayList<UserActiveCodeBean>(limit);
        List<Object> phaseCodeList = Lists.newArrayList();
        for (int i = 0; i < limit; ++i) {
            if (phaseCodeList == null || phaseCodeList.size() <= 0) {
                phaseCodeList = this.nextCode(RandomUtils.nextInt((int)50, (int)300));
            }
            String code = (String)phaseCodeList.remove(0);
            ActiveCodeDTO activeCode = ActiveCodeDTO.builder().activeCode(code).cardNo(cardNoList.get(i)).build();
            UserActiveCodeBean userActiveCode = new UserActiveCodeBean();
            userActiveCode.setId(this.sequenceCreater.nextLongId());
            userActiveCode.setCardType(ActiveCodeTypeEnum.CHANNEL.getCode());
            userActiveCode.setActiveCode(code);
            userActiveCode.setCardNo(cardNoList.get(i));
            userActiveCode.setMaxTimes(this.userVipProperties.getChannelCodeNum());
            userActiveCode.setActiveTimes(Integer.valueOf(0));
            userActiveCode.setAreaCode(areaCode);
            userActiveCode.setStatus(AppConst.ENABLE);
            userActiveCode.setCreateTime(new Date());
            result.add(activeCode);
            saveList.add(userActiveCode);
        }
        MybatisBatchBuilder.create(UserActiveCodeMapper.class, saveList).run((mapper, item) -> mapper.insert(item));
        return result;
    }

    @Override
    public List<ResultDTO> execBatchBind(List<OfflineBindRelationParam> bindRelationParams) {
        if (bindRelationParams == null) {
            return Lists.newArrayList();
        }
        HashMap tempUserMap = Maps.newHashMap();
        ArrayList resultDTOS = Lists.newArrayList();
        int index = 0;
        for (OfflineBindRelationParam bindRelationParam : bindRelationParams) {
            UserActiveCodeBean activeCode;
            User user = (User)tempUserMap.get(bindRelationParam.getPhoneNo());
            if (null == user) {
                user = this.userMapper.findByPhone(bindRelationParam.getPhoneNo());
                tempUserMap.put(bindRelationParam.getPhoneNo(), user);
            }
            ResultDTO result = ResultDTO.builder().success(Boolean.valueOf(true)).build();
            if (null == user) {
                result.setSuccess(Boolean.valueOf(false));
                result.appendResult("\u624b\u673a\u53f7\u7801[" + bindRelationParam.getPhoneNo() + "]\u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728");
            }
            if (null == (activeCode = this.userActiveCodeMapper.selectByCardNo(bindRelationParam.getCardNo()))) {
                result.setSuccess(Boolean.valueOf(false));
                result.appendResult("\u6fc0\u6d3b\u7801[" + bindRelationParam.getActiveCode() + "]\u4e0d\u5b58\u5728");
            }
            if (!result.getSuccess().booleanValue()) {
                result.setTitle(bindRelationParam.getPhoneNo());
                resultDTOS.add(result);
            }
            ++index;
        }
        return resultDTOS;
    }

    private void modifyRecord(UserActiveCodeBean activeCode, User user) {
        activeCode.setUserId(user.getId());
        this.userActiveCodeMapper.updateUserId(activeCode);
        if (Objects.equals(activeCode.getStatus(), AppConst.DISALBE)) {
            List relations = this.userActiveRelationMapper.selectByCode(activeCode.getActiveCode());
            if (CollectionUtils.isEmpty((Collection)relations)) {
                log.error("\u6fc0\u6d3b\u7801[{}]\u5df2\u4f7f\u7528\uff0c\u4f46\u662f\u672a\u53d1\u73b0\u5bf9\u5e94\u7684\u6fc0\u6d3b\u8bb0\u5f55", (Object)activeCode.getActiveCode());
            } else {
                relations.forEach(relation -> {
                    UserInviteOrderVO inviteInfo;
                    if (null != relation.getActiveUserId() && (inviteInfo = this.userInviteService.getInviteNumByUserId(relation.getActiveUserId())) == null) {
                        UserInviteBindDTO userInviteBindDTO = new UserInviteBindDTO();
                        this.bindInviteManager.bindInvite(userInviteBindDTO);
                    }
                });
            }
        }
    }
}

