/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.vip.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.rediskey.UserRedisKey;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.domain.UserVipHistoryMapper;
import com.bxm.localnews.user.domain.UserVipMapper;
import com.bxm.localnews.user.domain.vip.UserActiveCodeMapper;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.vip.ActiveCodeDTO;
import com.bxm.localnews.user.dto.vip.VipActivationResultDTO;
import com.bxm.localnews.user.enums.ActivationVipEnum;
import com.bxm.localnews.user.enums.ActivationVipStatusEnum;
import com.bxm.localnews.user.invite.InviteRecordService;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.model.VipCardInfoDTO;
import com.bxm.localnews.user.model.VipInfoDetailDTO;
import com.bxm.localnews.user.model.param.VipQueryParam;
import com.bxm.localnews.user.param.ActivationUserVipParam;
import com.bxm.localnews.user.param.VipActivationCodeParam;
import com.bxm.localnews.user.param.VipPaymentCallbackParam;
import com.bxm.localnews.user.properties.UserVipProperties;
import com.bxm.localnews.user.support.UserRankService;
import com.bxm.localnews.user.utils.NumberConvertUtils;
import com.bxm.localnews.user.vip.ActiveCodeService;
import com.bxm.localnews.user.vip.UserVipService;
import com.bxm.localnews.user.vip.VipCardService;
import com.bxm.localnews.user.vip.activation.ActivationVipManager;
import com.bxm.localnews.user.vip.code.ActiveCodeProcessContext;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserVip;
import com.bxm.localnews.user.vo.UserVipHistory;
import com.bxm.localnews.user.vo.vip.UserActiveCodeBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserVipServiceImpl
extends BaseService
implements UserVipService {
    private final UserVipProperties userVipProperties;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserVipMapper userVipMapper;
    private final UserVipHistoryMapper userVipHistoryMapper;
    private final ActivationVipManager activationVipManager;
    private final ActiveCodeService activeCodeService;
    private final VipCardService vipCardService;
    private UserService userService;
    private final UserActiveCodeMapper userActiveCodeMapper;
    private final InviteRecordService inviteRecordService;
    private UserAccountService userAccountService;
    private UserRankService userRankService;
    private final RedisSetAdapter redisSetAdapter;

    @Autowired
    public UserVipServiceImpl(UserVipProperties userVipProperties, RedisHashMapAdapter redisHashMapAdapter, UserVipMapper userVipMapper, UserVipHistoryMapper userVipHistoryMapper, ActivationVipManager activationVipManager, ActiveCodeService activeCodeService, VipCardService vipCardService, UserActiveCodeMapper userActiveCodeMapper, InviteRecordService inviteRecordService, UserAccountService userAccountService, UserRankService userRankService, RedisSetAdapter redisSetAdapter) {
        this.userVipProperties = userVipProperties;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userVipMapper = userVipMapper;
        this.userVipHistoryMapper = userVipHistoryMapper;
        this.activationVipManager = activationVipManager;
        this.activeCodeService = activeCodeService;
        this.vipCardService = vipCardService;
        this.userActiveCodeMapper = userActiveCodeMapper;
        this.inviteRecordService = inviteRecordService;
        this.userAccountService = userAccountService;
        this.userRankService = userRankService;
        this.redisSetAdapter = redisSetAdapter;
    }

    public UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)SpringContextHolder.getBean(UserService.class);
        }
        return this.userService;
    }

    @Override
    public List<VipCardInfoDTO> getVipCardList() {
        return this.userVipProperties.getCardConfig();
    }

    @Override
    public VipCardInfoDTO getVipCardInfo(String id) {
        List<VipCardInfoDTO> list = this.getVipCardList();
        for (VipCardInfoDTO entity : list) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    @Override
    public VipActivationResultDTO execActivationVipByCode(VipActivationCodeParam vipActivationCodeParam, Integer type) {
        this.checkParam(vipActivationCodeParam);
        ActivationUserVipParam param = new ActivationUserVipParam();
        BeanUtils.copyProperties((Object)vipActivationCodeParam, (Object)param);
        param.setCode(vipActivationCodeParam.getCode());
        param.setUserId(vipActivationCodeParam.getUserId());
        param.setActivationVipEnum(ActivationVipEnum.ACTIVATION_CODE);
        param.setPlatformEnum(Integer.valueOf(vipActivationCodeParam.getPlatform()));
        if (com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)param.getChannel())) {
            param.setChannel(vipActivationCodeParam.getChnl());
        }
        this.logger.debug("\u6fc0\u6d3b\u7801\u6fc0\u6d3b\u53c2\u6570\uff1a[{}]", (Object)JSONObject.toJSONString((Object)vipActivationCodeParam));
        if (Objects.equals(type, 1)) {
            VipActivationResultDTO result = new VipActivationResultDTO();
            this.noChanceToActiveVip(param, result);
            if (Objects.equals(result.getResult(), 1) || Objects.equals(result.getResult(), 0)) {
                return result;
            }
        }
        Message message = this.activationVipManager.activationVip(param);
        VipActivationResultDTO result = new VipActivationResultDTO();
        result.setMsg(message.getLastMessage());
        result.setResult((Integer)message.getParam("ak"));
        return result;
    }

    private void checkParam(VipActivationCodeParam param) {
        if (null == param.getUserId()) {
            throw new RuntimeException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)param.getCode())) {
            throw new RuntimeException("\u6fc0\u6d3b\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void noChanceToActiveVip(ActivationUserVipParam param, VipActivationResultDTO result) {
        if (Objects.equals(param.getPlatformEnum(), 3)) {
            User user = this.getUserService().selectByPrimaryKey(param.getUserId());
            if (!user.getState().equals((byte)2)) {
                result.setResult(Integer.valueOf(3));
                return;
            }
            UserActiveCodeBean activeCodeBean = this.userActiveCodeMapper.selectByCode(param.getCode());
            if (null == activeCodeBean) {
                result.setResult(Integer.valueOf(0));
                result.setMsg("\u6fc0\u6d3b\u7801\u9519\u8bef");
                return;
            }
            if (activeCodeBean.getMaxTimes() < 1) {
                this.inviteRecordService.addInviteRecord(activeCodeBean.getUserId(), param.getUserId(), param.getChannel());
                User userInvite = this.getUserService().selectByPrimaryKey(activeCodeBean.getUserId());
                String windowInfo = "\u54ce\u5440\u4f60\u6765\u665a\u4e86\n\u4f60\u7684\u597d\u53cb" + userInvite.getNickname() + "\u76845\u4e2aVIP\u540d\u989d\n\u5df2\u7ecf\u88ab\u5176\u4ed6\u670b\u53cb\u62a2\u5b8c\u4e86";
                this.redisHashMapAdapter.put(UserRedisKey.ACTIVE_VIP_HAS_NOT_CHANCE, String.valueOf(param.getUserId()), (Object)windowInfo);
                result.setResult(Integer.valueOf(1));
                result.setMsg("\u6fc0\u6d3b\u6210\u529f");
                return;
            }
        }
        result.setResult(Integer.valueOf(3));
    }

    @Override
    public Boolean execActivationVipByPay(VipPaymentCallbackParam callbackParam) {
        ActivationUserVipParam param = new ActivationUserVipParam();
        param.setOrderId(callbackParam.getOrderId());
        param.setPlatformEnum(Integer.valueOf(null == callbackParam.getPlatformEnum() ? PlatformEnum.ANDROID.getCode() : callbackParam.getPlatformEnum().intValue()));
        param.setChannel(callbackParam.getChannel());
        param.setUserId(callbackParam.getUserId());
        param.setVipCardId(callbackParam.getVipCardId());
        param.setActivationVipEnum(ActivationVipEnum.PAY);
        param.setPlatform(param.getPlatformEnum().intValue());
        param.setChnl(param.getChannel());
        return this.activationVipManager.activationVip(param).isSuccess();
    }

    @Override
    public Message createVip(ActivationUserVipParam param) {
        UserVip existsVip = this.userVipMapper.selectByUserId(param.getUserId());
        if (null != existsVip) {
            this.logger.warn("\u7528\u6237VIP\u8d44\u683c\u91cd\u590d\u6fc0\u6d3b\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
            return Message.build((boolean)false, (String)"\u7528\u6237\u5df2\u7ecf\u662fVIP,\u65e0\u9700\u91cd\u590d\u6fc0\u6d3b");
        }
        ActiveCodeProcessContext context = ActiveCodeProcessContext.builder().userId(param.getUserId()).code(param.getCode()).activationVipType(param.getActivationVipEnum()).build();
        ActiveCodeDTO activeCodeDTO = this.activeCodeService.process(context);
        Date now = new Date();
        UserVip userVip = new UserVip();
        userVip.setId(Long.valueOf(this.nextId()));
        userVip.setUserId(param.getUserId());
        userVip.setCard(activeCodeDTO.getCardNo());
        userVip.setActiveCode(activeCodeDTO.getActiveCode());
        userVip.setCreateTime(now);
        userVip.setChannel(param.getChannel());
        userVip.setStatus(Integer.valueOf(1));
        userVip.setExpiredDate(DateUtils.addField((Date)now, (int)6, (int)param.getDuration()));
        userVip.setType(param.getActivationVipEnum().getCode());
        int result = this.userVipMapper.insert(userVip);
        return this.saveVipHistory(param, now, userVip, result, "\u5f00\u901aVIP");
    }

    private Message saveVipHistory(ActivationUserVipParam param, Date now, UserVip userVip, int result, String operation) {
        UserVipHistory history = new UserVipHistory();
        history.setId(Long.valueOf(this.nextId()));
        history.setVipId(userVip.getId());
        history.setOperation(operation);
        history.setUserId(param.getUserId());
        history.setOrderId(param.getOrderId());
        history.setCreateTime(now);
        this.removeCache(param.getUserId());
        return Message.build((int)(result += this.userVipHistoryMapper.insert(history)));
    }

    @Override
    public Message execRenew(ActivationUserVipParam param) {
        UserVip userVip = this.getUserVipByUid(param.getUserId());
        if (userVip == null || userVip.getId() == null) {
            this.logger.warn("\u7eed\u7ea6\u65f6\uff0c\u7528\u6237\u672a\u5f00\u901aVIP\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
            return this.createVip(param);
        }
        Date now = new Date();
        userVip.setStatus(Integer.valueOf(ActivationVipStatusEnum.USEFUL.getStatus()));
        userVip.setExpiredDate(DateUtils.addField((Date)new Date(), (int)6, (int)param.getDuration()));
        int result = this.userVipMapper.vipRenew(userVip);
        return this.saveVipHistory(param, now, userVip, result, "\u91cd\u65b0\u5f00\u901aVIP");
    }

    private void execFixCardNo(UserVip userVip) {
        LocationUserInfoDTO locationUserInfo;
        if (Objects.equals(userVip.getUsable(), Boolean.TRUE) && StringUtils.isBlank((CharSequence)userVip.getCard()) && Objects.nonNull(locationUserInfo = this.getUserService().getLocationUserInfo(userVip.getUserId())) && StringUtils.isNotBlank((CharSequence)locationUserInfo.getLocationCode())) {
            String newCardNo = this.vipCardService.nextCard(locationUserInfo.getLocationCode());
            this.userVipMapper.updateCardNo(userVip.getUserId(), newCardNo);
            userVip.setCard(newCardNo);
            this.removeCache(userVip.getUserId());
            this.logger.info("\u586b\u5145\u7528\u6237\u5361\u53f7\u4fe1\u606f\uff0c\u7528\u6237ID\uff1a{},\u6240\u5c5e\u5730\u533a\uff1a{},\u5361\u53f7\uff1a{}", new Object[]{userVip.getId(), locationUserInfo.getLocationCode(), newCardNo});
        }
    }

    @Override
    public UserVip getUserVipByUid(Long userId) {
        KeyGenerator key = this.buildVipInfoCacheKey(userId);
        UserVip userVipInfo = (UserVip)this.redisHashMapAdapter.get(key, String.valueOf(userId), UserVip.class);
        if (null == userVipInfo) {
            userVipInfo = this.userVipMapper.selectByUserId(userId);
            if (null == userVipInfo) {
                userVipInfo = new UserVip(userId, Integer.valueOf(ActivationVipStatusEnum.WAIT_USE.getStatus()));
            } else {
                UserActiveCodeBean activeCodeInfo = this.activeCodeService.getActiveCode(userVipInfo.getActiveCode());
                userVipInfo.setLeftOpenNum(activeCodeInfo.getMaxTimes());
            }
            userVipInfo.setUsable(Boolean.valueOf(Objects.equals(ActivationVipStatusEnum.USEFUL.getStatus(), userVipInfo.getStatus())));
            this.redisHashMapAdapter.put(key, String.valueOf(userId), (Object)userVipInfo);
        }
        this.execFixCardNo(userVipInfo);
        return userVipInfo;
    }

    @Override
    public Boolean isVip(Long userId) {
        if (null == userId) {
            return false;
        }
        UserVip userVip = this.getUserVipByUid(userId);
        return Objects.equals(userVip.getStatus(), ActivationVipStatusEnum.USEFUL.getStatus());
    }

    @Override
    public List<UserVip> getExpiredVipList(Integer status, Date expiredDate) {
        return this.userVipMapper.getUserVipList(status, expiredDate);
    }

    @Override
    public int updateBatchStatusByUid(Integer status, List<Long> userIds) {
        return this.userVipMapper.updateBatchStatusByUid(status, userIds);
    }

    private KeyGenerator buildVipInfoCacheKey(Long userId) {
        return RedisConfig.USER_VIP_INFO.copy().appendKey((Object)(userId % 10L));
    }

    @Override
    public void removeCache(Long userId) {
        this.redisHashMapAdapter.remove(this.buildVipInfoCacheKey(userId), new String[]{String.valueOf(userId)});
    }

    @Override
    public VipInfoDetailDTO getVipDetail(VipQueryParam param) {
        UserVip userVip = this.getUserVipByUid(param.getUserId());
        VipInfoDetailDTO userVipDetail = new VipInfoDetailDTO();
        BeanUtils.copyProperties((Object)userVip, (Object)userVipDetail);
        userVipDetail.setExpiredDate(null == userVip.getExpiredDate() ? "" : DateUtils.formatDate((Date)userVip.getExpiredDate()));
        UserAccountDTO userAccount = this.userAccountService.getUserAccount(param.getUserId());
        if (userAccount.getSaveCash() != null) {
            userVipDetail.setRebateAmount(userAccount.getSaveCash());
        } else {
            userVipDetail.setRebateAmount(BigDecimal.ZERO);
        }
        UserInfoDTO userCache = this.getUserService().getUserCache(param.getUserId());
        userVipDetail.setNickName(userCache.getNickname());
        userVipDetail.setHeadImg(userCache.getHeadImg());
        userVipDetail.setPhone(com.bxm.newidea.component.tools.StringUtils.hideMobile((String)userCache.getPhone()));
        if ("MAIN".equals(param.getScene())) {
            String saveCashPercent;
            Long vipTotal;
            if (null == param.getAreaCode()) {
                vipTotal = 0L;
                saveCashPercent = "0%";
            } else {
                vipTotal = this.userRankService.getVipTotal(param.getAreaCode());
                Long saveCashRank = this.userRankService.getSaveCashRank(param.getUserId(), param.getAreaCode());
                Long total = this.userRankService.getTotal(param.getAreaCode());
                saveCashPercent = NumberConvertUtils.formatSaveCashPercent(saveCashRank, total, userAccount.getSaveCash());
            }
            userVipDetail.setRebatePercent(saveCashPercent);
            userVipDetail.setTotalVip(NumberConvertUtils.formatNum(vipTotal));
            this.consumeSaveCashEvent(param, userVipDetail);
        }
        return userVipDetail;
    }

    @Override
    public Boolean activeVipPay(ActivationUserVipParam param) {
        if (null == param.getUserId()) {
            return false;
        }
        param.setActivationVipEnum(ActivationVipEnum.PAY);
        param.setChannel("buy goods");
        param.setVipCardId("1");
        return this.activationVipManager.activationVip(param).isSuccess();
    }

    private void consumeSaveCashEvent(VipQueryParam param, VipInfoDetailDTO userVipDetail) {
        if (this.redisSetAdapter.exists(RedisConfig.HAS_NEW_SAVE_CASH_EVENT_CACHE, (Object)param.getUserId()).booleanValue()) {
            userVipDetail.setAddRebate(Boolean.TRUE);
            this.redisSetAdapter.remove(RedisConfig.HAS_NEW_SAVE_CASH_EVENT_CACHE, new Object[]{param.getUserId()});
        } else {
            userVipDetail.setAddRebate(Boolean.FALSE);
        }
    }
}

