/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.vip.impl;

import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.vip.VipCardService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VipCardServiceImpl
implements VipCardService {
    private static final Logger log = LoggerFactory.getLogger(VipCardServiceImpl.class);
    private final RedisStringAdapter redisStringAdapter;
    private static final long START_NUM = 100000L;
    private static final String DEFAULT_AREA = "330100000000";
    private static int AREA_LENGTH = 6;

    @Autowired
    public VipCardServiceImpl(RedisStringAdapter redisStringAdapter) {
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public String nextCard(String areaCode) {
        if (StringUtils.isBlank((CharSequence)areaCode) || areaCode.length() < AREA_LENGTH) {
            areaCode = DEFAULT_AREA;
            log.error("\u521b\u5efaVIP\u5361\u53f7\uff0c\u5730\u533a\u4fe1\u606f\u672a\u4f20\u9012\u6216\u957f\u5ea6\u9519\u8bef\uff0c\u4f7f\u7528\u4e86\u9ed8\u8ba4\u7684\u5730\u533a\uff1a{}\uff0c\u53c2\u6570\u5730\u533a\uff1a{}", (Object)DEFAULT_AREA, (Object)areaCode);
        }
        String subAreaCode = StringUtils.substring((String)areaCode, (int)0, (int)AREA_LENGTH);
        KeyGenerator key = this.buildKey(subAreaCode);
        long cardIndex = this.redisStringAdapter.incrementWithDefault(key, 100000L);
        return subAreaCode + String.format("%07d", cardIndex);
    }

    private KeyGenerator buildKey(String areaCode) {
        return RedisConfig.VIP_CARD_INDEX_KEY.copy().appendKey((Object)areaCode);
    }

    @Override
    public List<String> nextCard(String areaCode, int limit) {
        if (StringUtils.isBlank((CharSequence)areaCode) || areaCode.length() < AREA_LENGTH) {
            areaCode = DEFAULT_AREA;
            log.error("\u521b\u5efaVIP\u5361\u53f7\uff0c\u5730\u533a\u4fe1\u606f\u672a\u4f20\u9012\u6216\u957f\u5ea6\u9519\u8bef\uff0c\u4f7f\u7528\u4e86\u9ed8\u8ba4\u7684\u5730\u533a\uff1a{}\uff0c\u53c2\u6570\u5730\u533a\uff1a{}", (Object)DEFAULT_AREA, (Object)areaCode);
        }
        String subAreaCode = StringUtils.substring((String)areaCode, (int)0, (int)AREA_LENGTH);
        KeyGenerator key = this.buildKey(subAreaCode);
        ArrayList<String> cardNoList = new ArrayList<String>(limit);
        if (!this.redisStringAdapter.hasKey(key).booleanValue()) {
            this.redisStringAdapter.set(key, 100000L);
        }
        long cardIndex = this.redisStringAdapter.increment(key, limit);
        for (int i = limit - 1; i >= 0; --i) {
            cardNoList.add(subAreaCode + String.format("%07d", cardIndex - (long)i));
        }
        return cardNoList;
    }
}

