/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.activity.service.impl;

import com.bxm.newidea.wanzhuan.activity.domain.ActivityMapper;
import com.bxm.newidea.wanzhuan.activity.service.ActivityService;
import com.bxm.newidea.wanzhuan.activity.vo.Activity;
import com.bxm.newidea.wanzhuan.activity.vo.ActivityDTO;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="activityService")
public class ActivityServiceImpl
implements ActivityService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityServiceImpl.class);
    @Resource
    private ActivityMapper activityMapper;

    @Override
    public Page<Activity> selectPageList(Integer current, Integer pageSize) {
        PageHelper.startPage((int)(current == null ? 1 : current), (int)(pageSize == null ? 10 : pageSize));
        List<Activity> list = this.activityMapper.selectPageList();
        return (Page)list;
    }

    @Override
    public void updateWaitActivityState(Byte state) {
        List<Activity> activities = this.activityMapper.selectByState(state);
        for (Activity a : activities) {
            Date date = new Date();
            try {
                if (!date.after(a.getStartTime())) continue;
                a.setState(Activity.STATE.RUNNING);
                this.activityMapper.updateByPrimaryKeySelective(a);
            }
            catch (Exception e) {
                logger.error("\u5b9a\u65f6\u66f4\u65b0\u7b49\u5f85\u7684\u6d3b\u52a8\u9519\u8bef\uff0cid=" + a.getId());
            }
        }
    }

    @Override
    public void updateRunActivityState(Byte state) {
        List<Activity> activities = this.activityMapper.selectByState(state);
        for (Activity a : activities) {
            Date date = new Date();
            try {
                if (!date.after(a.getEndTime())) continue;
                a.setState(Activity.STATE.CLOSED);
                this.activityMapper.updateByPrimaryKeySelective(a);
            }
            catch (Exception e) {
                logger.error("\u5b9a\u65f6\u66f4\u65b0\u8fdb\u884c\u7684\u6d3b\u52a8\u9519\u8bef\uff0cid=" + a.getId());
            }
        }
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return this.activityMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int insert(Activity record) {
        return this.activityMapper.insert(record);
    }

    @Override
    public int insertSelective(Activity record) {
        return this.activityMapper.insertSelective(record);
    }

    @Override
    public Activity selectByPrimaryKey(Long id) {
        return this.activityMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(Activity record) {
        return this.activityMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int updateByPrimaryKey(Activity record) {
        return this.activityMapper.updateByPrimaryKey(record);
    }

    @Override
    public List<Activity> selectPageList() {
        return this.activityMapper.selectPageList();
    }

    @Override
    public List<Activity> selectByState(Byte state) {
        return this.activityMapper.selectByState(state);
    }

    @Override
    public Integer getActivityCount(ActivityDTO activityDTO) {
        return this.activityMapper.getActivityCount(activityDTO);
    }

    @Override
    public List<Activity> getActivityByParams(ActivityDTO activityDTO) {
        return this.activityMapper.getActivityByParams(activityDTO);
    }

    @Override
    public int updateActivityStateByIds(String[] ids, Byte state) {
        return this.activityMapper.updateActivityStateByIds(ids, state);
    }
}

