/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.activity.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.wanzhuan.activity.domain.DailyTaskMapper;
import com.bxm.newidea.wanzhuan.activity.domain.InviteRelationMapper;
import com.bxm.newidea.wanzhuan.activity.domain.NoviceTaskRecordMapper;
import com.bxm.newidea.wanzhuan.activity.enums.TaskTypeEnum;
import com.bxm.newidea.wanzhuan.activity.model.AwakenStateModel;
import com.bxm.newidea.wanzhuan.activity.model.InviteRelation;
import com.bxm.newidea.wanzhuan.activity.model.PrenticeRankingModel;
import com.bxm.newidea.wanzhuan.activity.service.InviteRelationService;
import com.bxm.newidea.wanzhuan.activity.vo.DailyTask;
import com.bxm.newidea.wanzhuan.activity.vo.NoviceTaskRecord;
import com.bxm.newidea.wanzhuan.base.constant.AppConst;
import com.bxm.newidea.wanzhuan.base.constant.RedisConfig;
import com.bxm.newidea.wanzhuan.base.constant.RedisContents;
import com.bxm.newidea.wanzhuan.base.service.PushMessageService;
import com.bxm.newidea.wanzhuan.base.service.ShortLinkService;
import com.bxm.newidea.wanzhuan.base.service.SmsService;
import com.bxm.newidea.wanzhuan.base.service.SysConfigRedis;
import com.bxm.newidea.wanzhuan.base.vo.ShortLinkReq;
import com.bxm.newidea.wanzhuan.points.service.PayFlowService;
import com.bxm.newidea.wanzhuan.points.service.UserAmountService;
import com.bxm.newidea.wanzhuan.points.service.UserRewardStatService;
import com.bxm.newidea.wanzhuan.points.service.WaitRewardService;
import com.bxm.newidea.wanzhuan.points.vo.PayFlow;
import com.bxm.newidea.wanzhuan.points.vo.PrenticeStatModel;
import com.bxm.newidea.wanzhuan.points.vo.UserAmount;
import com.bxm.newidea.wanzhuan.points.vo.WaitReward;
import com.bxm.newidea.wanzhuan.security.model.AddressBookDTO;
import com.bxm.newidea.wanzhuan.security.model.User;
import com.bxm.newidea.wanzhuan.security.model.UserInfoDTO;
import com.bxm.newidea.wanzhuan.security.service.UserService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="inviteRelationService")
public class InviteRelationServiceImpl
implements InviteRelationService {
    private static final Logger logger = LoggerFactory.getLogger(InviteRelationServiceImpl.class);
    private static final String AWAKEN_SHARE_TITLE = "\u5e08\u7236\u8981\u7ed9\u4f60\u53d1\u91d1\u5e01\u4e86\uff01\uff01\uff01";
    private static final String AWAKEN_SHARE_CONTENT = "\u4f60\u5df2\u7ecf\u597d\u4e45\u6ca1\u6765\u73a9\u8d5a\u5934\u6761\u8d5a\u53d6\u96f6\u82b1\u94b1\u4e86\uff0c\u9001\u4f60500\u91d1\u5e01\uff0c\u8d76\u5feb\u56de\u6765\u8d5a\u94b1\u5427";
    private static final String APPRENTICE_SHARE_TITLE = "\u770b\u65b0\u95fb\u4e5f\u80fd\u8d5a\u53d6\u96f6\u82b1\u94b1\uff01\uff01\uff01";
    private static final String APPRENTICE_SHARE_CONTENT = "\u6211\u5df2\u7ecf\u5728\u73a9\u8d5a\u5934\u6761\u8d5a\u4e86money\u5143\u4e86\uff0c\u8d76\u5feb\u548c\u6211\u4e00\u8d77\u8d5a\u53d6\u96f6\u82b1\u94b1\u5427";
    @Resource
    private NoviceTaskRecordMapper noviceTaskRecordMapper;
    @Resource
    private DailyTaskMapper dailyTaskMapper;
    @Resource
    private WaitRewardService waitRewardService;
    @Resource
    private InviteRelationMapper inviteRelationMapper;
    @Resource
    private SmsService smsService;
    @Resource
    private PayFlowService payFlowService;
    @Resource
    private UserRewardStatService userRewardStatService;
    @Resource
    private PushMessageService pushMessageService;
    @Resource
    private UserService userService;
    @Resource
    private ShortLinkService shortLinkService;
    @Resource
    private UserAmountService userAmountService;
    @Resource
    private SysConfigRedis sysConfigRedis;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    public int addInviteRelation(Long userId, Long masterId) {
        long firstRecruitId;
        NoviceTaskRecord masterTask;
        InviteRelation addInviteRelation = new InviteRelation();
        addInviteRelation.setUserId(userId);
        addInviteRelation.setUpUserId(masterId);
        this.inviteRelationMapper.insertSelective(addInviteRelation);
        long apprenticeId = TaskTypeEnum.APPRENTICE.getType();
        NoviceTaskRecord userTask = this.noviceTaskRecordMapper.findSelectiveByType(apprenticeId, userId);
        if (null != userTask && 0 == userTask.getState()) {
            DailyTask dailyTask = this.dailyTaskMapper.selectByPrimaryKey(apprenticeId);
            PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.APPRENTICE.getType(), (Byte)dailyTask.getRewardType(), (String)addInviteRelation.getId().toString());
            this.payFlowService.modifyAccountFlowAndStatByCoin(payFlow, dailyTask.getReward());
            userTask.setState((byte)1);
            this.noviceTaskRecordMapper.updateByPrimaryKeySelective(userTask);
        }
        if (null != (masterTask = this.noviceTaskRecordMapper.findSelectiveByType(firstRecruitId = (long)TaskTypeEnum.RECRUIT_FIRST.getType(), masterId)) && 0 == masterTask.getState()) {
            DailyTask dailyTask = this.dailyTaskMapper.selectByPrimaryKey(firstRecruitId);
            WaitReward waitReward = new WaitReward();
            waitReward.setUserId(masterId);
            waitReward.setTaskType(Byte.valueOf(TaskTypeEnum.RECRUIT_FIRST.getType()));
            waitReward.setRewardType(dailyTask.getRewardType());
            waitReward.setReward(dailyTask.getReward());
            waitReward.setSendTime(new Date());
            waitReward.setSendState(Byte.valueOf((byte)0));
            waitReward.setRelationId(userId.toString());
            waitReward.setRemark(TaskTypeEnum.RECRUIT_FIRST.getDesc());
            this.waitRewardService.addWaitReward(TaskTypeEnum.RECRUIT_FIRST, waitReward);
            this.recruitFirstReward(addInviteRelation, dailyTask);
            masterTask.setState((byte)1);
            this.noviceTaskRecordMapper.updateByPrimaryKeySelective(masterTask);
        } else {
            long recruitId = TaskTypeEnum.ADD_RECRUIT.getType();
            DailyTask dailyTask = this.dailyTaskMapper.selectByPrimaryKey(recruitId);
            WaitReward waitReward = new WaitReward();
            waitReward.setUserId(masterId);
            waitReward.setTaskType(Byte.valueOf(TaskTypeEnum.ADD_RECRUIT.getType()));
            waitReward.setRewardType(dailyTask.getRewardType());
            waitReward.setReward(dailyTask.getReward());
            waitReward.setSendTime(new Date());
            waitReward.setSendState(Byte.valueOf((byte)0));
            waitReward.setRelationId(userId.toString());
            waitReward.setRemark(TaskTypeEnum.ADD_RECRUIT.getDesc());
            this.waitRewardService.addWaitReward(TaskTypeEnum.ADD_RECRUIT, waitReward);
        }
        InviteRelation inviteRelation = this.inviteRelationMapper.findselectiveByUserId(masterId, null);
        if (null != inviteRelation) {
            long discipleId = TaskTypeEnum.ADD_DISCIPLE.getType();
            DailyTask dailyTask = this.dailyTaskMapper.selectByPrimaryKey(discipleId);
            WaitReward waitReward = new WaitReward();
            waitReward.setUserId(inviteRelation.getUpUserId());
            waitReward.setTaskType(Byte.valueOf(TaskTypeEnum.ADD_DISCIPLE.getType()));
            waitReward.setRewardType(dailyTask.getRewardType());
            waitReward.setReward(dailyTask.getReward());
            waitReward.setSendTime(new Date());
            waitReward.setSendState(Byte.valueOf((byte)0));
            waitReward.setRelationId(userId.toString());
            waitReward.setRemark(TaskTypeEnum.ADD_DISCIPLE.getDesc());
            this.waitRewardService.addWaitReward(TaskTypeEnum.ADD_DISCIPLE, waitReward);
        }
        this.insertPrenticeshipToRedis(userId, masterId);
        this.statisPrenticesToRedis(masterId);
        this.pushMessageService.recruitSuccess(masterId, this.userService.getUserFromRedisDB(userId.longValue()).getPhone());
        return 1;
    }

    private void recruitFirstReward(InviteRelation inviteRelation, DailyTask dailyTask) {
        PayFlow payFlow = PayFlow.initPayFlow((Long)inviteRelation.getUpUserId(), (Byte)TaskTypeEnum.RECRUIT_FIRST.getType(), (Byte)dailyTask.getRewardType(), (String)inviteRelation.getId().toString());
        BigDecimal coin = this.sysConfigRedis.getBigDecimal("BUSINESS", RedisContents.RECRUIT_FIRST_REWARD);
        this.payFlowService.modifyAccountFlowAndStatByCoin(payFlow, coin);
        UserInfoDTO dto = this.userService.getUserFromRedisDB(inviteRelation.getUserId().longValue());
        this.pushMessageService.firstRecruit(inviteRelation.getUpUserId(), dto.getPhone(), coin.toString());
    }

    private void statisPrenticesToRedis(long masterId) {
        String weekStartDate = this.getWeekStartDate();
        RedisKeyGenerator key = RedisKeyGenerator.build((String)RedisConfig.APPRENTICES);
        RedisKeyGenerator weekKey = RedisKeyGenerator.build((String)(RedisConfig.WEEK_APPRENTICES + weekStartDate));
        this.redisHashMapAdapter.increment((KeyGenerator)key, masterId + "", 1);
        this.redisHashMapAdapter.increment((KeyGenerator)weekKey, masterId + "", 1);
    }

    private void insertPrenticeshipToRedis(Long userId, Long masterId) {
        PrenticeStatModel.Master master = this.userRewardStatService.getBasicInfo(masterId);
        String masterKey = RedisConfig.RewardStat.MASTER_INFO + ":" + userId;
        this.redisStringAdapter.set((KeyGenerator)RedisKeyGenerator.build((String)masterKey), (Object)JSON.toJSONString((Object)master), 600L);
    }

    public void quartzManageUserState() {
        List<AwakenStateModel> relationList = this.inviteRelationMapper.listActiveAndWait();
        if (relationList == null || relationList.isEmpty()) {
            return;
        }
        for (AwakenStateModel relation : relationList) {
            if (10 != relation.getAwakenState() || DateUtils.getDiffDays((Date)relation.getLastLoginTime(), (Date)new Date()) < 7) continue;
            this.inviteRelationMapper.updateUserState(relation.getId(), (byte)20);
        }
    }

    public void grantAwakeReward(InviteRelation relation) {
        BigDecimal attributeGold = this.payFlowService.attributeGold4OneDay(relation.getUpUserId(), relation.getAwakenStartTime());
        if (attributeGold != null && attributeGold.compareTo(AppConst.AWAKE_TRIBUTE_GOLD) >= 0) {
            PayFlow payFlow = PayFlow.initPayFlow((Long)relation.getUpUserId(), (Byte)TaskTypeEnum.AWAKE_PUPIL.getType(), (Byte)10, null);
            this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, AppConst.AWAKE_REWARD, false);
            UserInfoDTO dto = this.userService.getUserFromRedisDB(relation.getUserId().longValue());
            this.pushMessageService.wakeApprentice(relation.getUpUserId(), dto.getPhone(), AppConst.AWAKE_REWARD.toString());
        }
        this.inviteRelationMapper.updateClearState(relation.getUserId());
    }

    public Object awakePrenticesSuccess(Long[] ids, Long userId) {
        for (Long prenticeId : ids) {
            if (this.inviteRelationMapper.checkAwakeState(userId, prenticeId) == null) {
                logger.error("\u4fe1\u606f\u6709\u8bef\u6216\u65e0\u9700\u5524\u9192,userId:" + userId + ",prenticeId:" + prenticeId);
                break;
            }
            this.inviteRelationMapper.awakeUser(prenticeId);
        }
        return ResultUtil.genSuccessResult();
    }

    public int countUserPrentice(Byte type, long upUserId) {
        String strCount;
        RedisKeyGenerator key = RedisKeyGenerator.build((String)RedisConfig.APPRENTICES);
        if (1 == type) {
            String weekStartDate = this.getWeekStartDate();
            key = RedisKeyGenerator.build((String)(RedisConfig.WEEK_APPRENTICES + weekStartDate));
        }
        if (StringUtils.isNotBlank((CharSequence)(strCount = (String)this.redisHashMapAdapter.get((KeyGenerator)key, upUserId + "")))) {
            return Integer.valueOf(strCount);
        }
        Date date = null;
        if (1 == type) {
            date = DateUtils.clearTimePart((Date)DateUtils.getWeekStartDate());
        }
        int count = this.inviteRelationMapper.countUserPrentice(upUserId, date);
        this.redisHashMapAdapter.put((KeyGenerator)key, upUserId + "", (Object)(count + ""));
        return count;
    }

    private String getWeekStartDate() {
        return ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(DateUtils.getWeekStartDate());
    }

    public Object awakeAllPrentices(Long userId, String ip) {
        List<User> userList = this.inviteRelationMapper.listUnActivePrentices(userId);
        if (userList == null || userList.isEmpty()) {
            return ResultUtil.genFailedResult((String)"\u65e0\u53ef\u5524\u9192\u5f92\u5f1f\u54e6");
        }
        for (User user : userList) {
            this.smsService.sendSmsByType(Byte.valueOf((byte)4), user.getPhone(), null);
        }
        return ResultUtil.genSuccessResult((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public Object awakePrentice(Long userId, Long prenticeId, String ip) {
        User user = this.userService.getPhone(prenticeId);
        if (user == null || this.inviteRelationMapper.checkAwakeState(userId, prenticeId) == null) {
            return ResultUtil.genFailedResult((String)"\u4fe1\u606f\u6709\u8bef\u6216\u65e0\u9700\u5524\u9192");
        }
        this.smsService.sendSmsByType(Byte.valueOf((byte)4), user.getPhone(), null);
        return ResultUtil.genSuccessResult((Object)"\u53d1\u9001\u6210\u529f");
    }

    public int updateUserAwakenState(Long userId) {
        InviteRelation relation = this.inviteRelationMapper.getInviteRelationByUserId(userId);
        if (null == relation) {
            return 1;
        }
        if (30 == relation.getAwakenState()) {
            long hours = Math.abs((System.currentTimeMillis() - relation.getAwakenStartTime().getTime()) / 3600000L);
            if (hours > 24L) {
                this.inviteRelationMapper.updateUserState(relation.getId(), (byte)10);
                logger.info(userId + "\u7528\u6237\u5524\u919224\u5c0f\u65f6\u540e\u767b\u5f55");
            } else {
                logger.info(userId + "\u7528\u6237\u5524\u919224\u5c0f\u65f6\u5185\u767b\u5f55");
                this.inviteRelationMapper.updateUserActive(relation.getId());
            }
            return 1;
        }
        if (20 == relation.getAwakenState()) {
            this.inviteRelationMapper.updateUserState(relation.getId(), (byte)10);
        }
        return 1;
    }

    public Object getShareMessage(Long userId, Byte type) {
        Map<String, Object> map = null;
        if (2 == type) {
            map = this.getShareApprenticeMessage(userId);
        }
        if (1 == type) {
            map = this.getShareAwakenMessage(userId);
        }
        return ResultUtil.genSuccessResult(map);
    }

    public Object getApprenticeInfo(Long userId, Byte type) {
        UserInfoDTO dto = this.userService.getUserFromRedisDB(userId.longValue());
        HashMap map = Maps.newHashMap();
        if (null == dto) {
            return ResultUtil.genFailedResult((int)510, (String)"\u786e\u5b9e\u53c2\u6570");
        }
        map.put("nickName", dto.getNickame());
        if (1 == type) {
            map.put("headImg", dto.getHeadImg());
            map.put("income", this.userAmountService.findAmountByUserId(userId).getTotalRmbBalance());
            map.put("reward", new BigDecimal(0.5));
        } else {
            map.put("reward", new BigDecimal(1.0));
        }
        return ResultUtil.genSuccessResult((Object)map);
    }

    public InviteRelation getInviteRelationByUserId(Long userId) {
        return this.inviteRelationMapper.getInviteRelationByUserId(userId);
    }

    public BigDecimal getTotalAttributedGold(Long userId) {
        return this.inviteRelationMapper.getTotalAttributedGold(userId);
    }

    public BigDecimal getTotalDisplineCoin(Long userId) {
        return this.inviteRelationMapper.getTotalDisplineCoin(userId);
    }

    public List<PrenticeRankingModel> listTopRanking() {
        return this.inviteRelationMapper.listTopRanking();
    }

    public Object apprentice(long userId, long masterId) {
        UserInfoDTO dto = this.userService.getUserFromRedisDB(masterId);
        if (null == dto) {
            return ResultUtil.genFailedResult((int)503, (String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9080\u8bf7\u7801");
        }
        InviteRelation inviteRelation = this.inviteRelationMapper.findselectiveByUserId(userId, null);
        if (null != inviteRelation) {
            return ResultUtil.genFailedResult((int)503, (String)"\u4e0d\u80fd\u91cd\u590d\u62dc\u5e08");
        }
        if (userId == masterId) {
            return ResultUtil.genFailedResult((int)503, (String)"\u60a8\u4e0d\u80fd\u62dc\u81ea\u5df1\u4e3a\u5e08\u5085");
        }
        UserInfoDTO userDto = this.userService.getUserFromRedisDB(userId);
        if (userDto.getCreateTime().before(dto.getCreateTime())) {
            return ResultUtil.genFailedResult((int)503, (String)"\u8be5\u7528\u6237\u7684\u6ce8\u518c\u65f6\u95f4\u665a\u4e8e\u60a8\uff0c\u65e0\u6cd5\u62dc\u5e08");
        }
        this.addInviteRelation(userId, masterId);
        return ResultUtil.genSuccessMsg((String)"\u62dc\u5e08\u6210\u529f");
    }

    public Message updateAttribute(Long userId, BigDecimal attributeGold) {
        return Message.build((int)this.inviteRelationMapper.updateAttribute(userId, attributeGold));
    }

    public int countUserEffectivePrentice(Long userId) {
        return this.inviteRelationMapper.countUserEffectivePrentice(userId);
    }

    public Message updateUpUpCoin(BigDecimal upCoin, Long userId) {
        return Message.build((int)this.inviteRelationMapper.updateUpUpCoin(upCoin, userId));
    }

    public int getInviteRelationCountByUserId(AddressBookDTO inviteRelation) {
        return this.inviteRelationMapper.getInviteRelationCountByUserId(inviteRelation);
    }

    public List<InviteRelation> getInviteRelationListByUserId(AddressBookDTO inviteRelation) {
        return this.inviteRelationMapper.getInviteRelationListByUserId(inviteRelation);
    }

    private Map<String, Object> getShareApprenticeMessage(Long userId) {
        UserAmount amount = this.userAmountService.findAmountByUserId(userId);
        HashMap map = Maps.newHashMap();
        map.put("title", APPRENTICE_SHARE_TITLE);
        map.put("content", APPRENTICE_SHARE_CONTENT.replaceAll("money", amount.getTotalRmbBalance().toString()));
        ShortLinkReq req = new ShortLinkReq();
        req.setType(Byte.valueOf((byte)1));
        req.setUserId(userId);
        Map m = this.shortLinkService.getRegisterShortUrl(req);
        map.putAll(m);
        return map;
    }

    private Map<String, Object> getShareAwakenMessage(Long userId) {
        HashMap map = Maps.newHashMap();
        map.put("title", AWAKEN_SHARE_TITLE);
        map.put("content", AWAKEN_SHARE_CONTENT);
        ShortLinkReq req = new ShortLinkReq();
        req.setType(Byte.valueOf((byte)2));
        req.setUserId(userId);
        Map m = this.shortLinkService.getRegisterShortUrl(req);
        map.putAll(m);
        return map;
    }
}

