/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.activity.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.activity.domain.LevelConfigMapper;
import com.bxm.newidea.wanzhuan.activity.model.LevelConfig;
import com.bxm.newidea.wanzhuan.activity.service.LevelConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LevelConfigServiceImpl
implements LevelConfigService {
    private static final RedisKeyGenerator CONFIG_REDIS_KEY = RedisKeyGenerator.build((String)"levelConfig");
    private LevelConfigMapper levelConfigMapper;
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public LevelConfigServiceImpl(LevelConfigMapper levelConfigMapper, RedisStringAdapter redisStringAdapter) {
        this.levelConfigMapper = levelConfigMapper;
        this.redisStringAdapter = redisStringAdapter;
    }

    public List<LevelConfig> getLevelConfigs() {
        List result;
        String configJson = (String)this.redisStringAdapter.get((KeyGenerator)CONFIG_REDIS_KEY);
        if (StringUtils.isBlank((CharSequence)configJson)) {
            result = this.levelConfigMapper.listAll();
            this.redisStringAdapter.set((KeyGenerator)CONFIG_REDIS_KEY, (Object)JSON.toJSONString((Object)result), 604800L);
        } else {
            result = JSON.parseArray((String)configJson, LevelConfig.class);
        }
        return result;
    }

    public LevelConfig selectByPrimaryKey(Long id) {
        return this.levelConfigMapper.selectByPrimaryKey(id);
    }
}

