/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.activity.service.impl;

import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.activity.domain.DailyTaskMapper;
import com.bxm.newidea.wanzhuan.activity.enums.TaskTypeEnum;
import com.bxm.newidea.wanzhuan.activity.service.MissionService;
import com.bxm.newidea.wanzhuan.activity.vo.DailyTask;
import com.bxm.newidea.wanzhuan.activity.vo.MissionModel;
import com.bxm.newidea.wanzhuan.activity.vo.UserMissionModel;
import com.bxm.newidea.wanzhuan.base.constant.AppConst;
import com.bxm.newidea.wanzhuan.base.service.SysConfigRedis;
import com.bxm.newidea.wanzhuan.points.service.BusinessCalService;
import com.bxm.newidea.wanzhuan.points.service.PayFlowService;
import com.bxm.newidea.wanzhuan.points.service.UserAmountService;
import com.bxm.newidea.wanzhuan.points.vo.PayFlow;
import com.bxm.newidea.wanzhuan.points.vo.UserAmount;
import com.bxm.newidea.wanzhuan.security.model.User;
import com.bxm.newidea.wanzhuan.security.service.UserService;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="missionService")
public class MissionServiceImpl
implements MissionService {
    private static final Logger logger = LoggerFactory.getLogger(MissionServiceImpl.class);
    @Resource
    private DailyTaskMapper dailyTaskMapper;
    private PayFlowService payFlowService;
    @Resource
    private SysConfigRedis sysConfigRedis;
    @Resource
    private UserService userService;
    @Resource
    private UserAmountService userAmountService;
    @Resource
    private BusinessCalService businessCalService;
    @Resource
    private RedisStringAdapter redisStringAdapter;

    private PayFlowService getPayFlowService() {
        if (null == this.payFlowService) {
            this.payFlowService = (PayFlowService)SpringContextHolder.getBean(PayFlowService.class);
        }
        return this.payFlowService;
    }

    public Object listMissions(Long userId) {
        MissionModel retModel = new MissionModel();
        retModel.setHotImg(this.sysConfigRedis.getValue("BUSINESS", "hot_img_url"));
        List<UserMissionModel> userTask = this.dailyTaskMapper.listMissions(userId);
        int count = 0;
        for (UserMissionModel model : userTask) {
            if (DailyTask.NEWBIEW_TASK.equals(model.getType())) {
                retModel.addNewbieTask(model);
                if (1 == model.getNewbiewTaskState()) {
                    ++count;
                }
                if (model.getNewbiewTaskCount() != count) continue;
                retModel.setNewbieTaskList(new ArrayList<UserMissionModel>());
                continue;
            }
            retModel.addDailyTask(model);
        }
        retModel = this.sortResult(retModel);
        return ResultUtil.genSuccessResult((Object)retModel);
    }

    private MissionModel sortResult(MissionModel retModel) {
        this.sortList(retModel.getNewbieTaskList());
        this.sortList(retModel.getDailyTaskList());
        return retModel;
    }

    private void sortList(List<UserMissionModel> list) {
        list.sort(Comparator.comparingInt(UserMissionModel::getNewbiewTaskState));
    }

    public Object shareReward(Byte shareType, Long userId) {
        if (1 == shareType) {
            this.shareFriendReward(userId);
        } else if (2 == shareType) {
            this.shareFriendCircleReward(userId);
        } else if (3 == shareType) {
            this.baskIncomeReward(userId);
        }
        return ResultUtil.genSuccessResult();
    }

    private String getCurrentDateStr() {
        return ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
    }

    private Object shareFriendCircleReward(Long userId) {
        String key = "shareFriendCircle_" + userId + this.getCurrentDateStr();
        int number = this.getRedisNum(key, 3);
        if (number <= 0) {
            return ResultUtil.genSuccessResult();
        }
        PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.ECRUIT_BY_SHARE_FRIEND.getType(), (Byte)10, null);
        this.getPayFlowService().modifyAccountFlowAndStatByGold(payFlow, AppConst.SHARE_FRIEND_GOLD_NUM, false);
        this.redisStringAdapter.set((KeyGenerator)RedisKeyGenerator.build((String)key), (Object)(number - 1 + ""), (long)DateUtils.getCurSeconds());
        return ResultUtil.genSuccessResult();
    }

    private Object shareFriendReward(Long userId) {
        String key = "shareFriend_" + userId + this.getCurrentDateStr();
        int number = this.getRedisNum(key, 3);
        if (number <= 0) {
            return ResultUtil.genSuccessResult();
        }
        PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.ECRUIT_BY_SHARE_WEIXIN.getType(), (Byte)10, null);
        this.getPayFlowService().modifyAccountFlowAndStatByGold(payFlow, AppConst.SHARE_WEIXIN_GOLD_NUM, false);
        this.redisStringAdapter.set((KeyGenerator)RedisKeyGenerator.build((String)key), (Object)(number - 1 + ""), (long)DateUtils.getCurSeconds());
        return ResultUtil.genSuccessResult();
    }

    private Object baskIncomeReward(Long userId) {
        String key = "bask_income_" + userId + this.getCurrentDateStr();
        int number = this.getRedisNum(key, 3);
        if (number <= 0) {
            return ResultUtil.genSuccessResult();
        }
        PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.DIVULGE_INCOME.getType(), (Byte)10, null);
        this.getPayFlowService().modifyAccountFlowAndStatByGold(payFlow, AppConst.BASK_INCOME_GOLD_NUM, false);
        this.redisStringAdapter.set((KeyGenerator)RedisKeyGenerator.build((String)key), (Object)(number - 1 + ""), (long)DateUtils.getCurSeconds());
        return ResultUtil.genSuccessResult();
    }

    private int getRedisNum(String key, int typeNum) {
        String num = (String)this.redisStringAdapter.get((KeyGenerator)RedisKeyGenerator.build((String)key));
        return StringUtils.isNotBlank((CharSequence)num) ? Integer.valueOf(num) : typeNum;
    }

    public void grantLevelSubsidy(User user) {
        BigDecimal gold = this.businessCalService.calculateSubsidyGold(user.getLevel());
        if (this.getPayFlowService().hasGrantSubsidyThisMonth(user.getId(), gold)) {
            logger.info("\u5df2\u9886\u53d6\u7b49\u7ea7\u5956\u52b1,userId:" + user.getId());
            return;
        }
        PayFlow payFlow = PayFlow.initPayFlow((Long)user.getId(), (Byte)TaskTypeEnum.LEVEL_REWARD_PER_MONTH.getType(), (Byte)10, null);
        this.getPayFlowService().modifyAccountFlowAndStatByGold(payFlow, gold, false);
    }

    public Object baskInfo(Long userId) {
        HashMap<String, Number> retMap = new HashMap<String, Number>();
        UserAmount userAmount = this.userAmountService.selectByUserId(userId);
        retMap.put("totalCoin", userAmount.getTotalRmbBalance());
        retMap.put("inviteCode", userAmount.getUserId());
        return ResultUtil.genSuccessResult(retMap);
    }
}

