/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.activity.service.impl;

import com.bxm.newidea.common.properties.BizConfigProperties;
import com.bxm.newidea.common.service.AbstractSplitTablePerMonthService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.wanzhuan.activity.domain.MoneyTreeRewardRecordMapper;
import com.bxm.newidea.wanzhuan.activity.service.MoneyTreeRewardRecordService;
import com.bxm.newidea.wanzhuan.activity.vo.MoneyTreeRewardRecord;
import com.bxm.newidea.wanzhuan.base.exception.BusinessException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="moneyTreeRewardRecordService")
public class MoneyTreeRewardRecordServiceImpl
extends AbstractSplitTablePerMonthService
implements MoneyTreeRewardRecordService {
    private static final Logger logger = LoggerFactory.getLogger(MoneyTreeRewardRecordServiceImpl.class);
    private static final String DEFAULT_TABLE_NAME = "b_money_tree_reward_record";
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private MoneyTreeRewardRecordMapper recordMapper;

    protected String getDefaultTableName() {
        return DEFAULT_TABLE_NAME;
    }

    protected Map<String, Object> loadTableStatus(String tableName) {
        return this.recordMapper.loadTableStatus(tableName);
    }

    protected void createTable(String nextTableName, long autoIncrement) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("nextTableName", nextTableName);
        data.put("autoIncrement", autoIncrement);
        this.recordMapper.createTable(data);
    }

    protected Date customSplitTableStartMonth() {
        String payFlowStartMonth = this.bizConfigProperties.getPayFlowSplitStartMonth();
        Date date = null;
        try {
            date = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_WITHOUT_DAY_FORMAT.get()).parse(payFlowStartMonth);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return date;
    }

    private String getLastTableName() {
        String result = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_WITHOUT_DAY_FORMAT.get()).format(DateUtils.addField((Date)new Date(), (int)2, (int)-1));
        return "b_money_tree_reward_record_" + result;
    }

    protected void alterTableIncrement(String tableName, long autoIncrement) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("tableName", tableName);
        data.put("autoIncrement", autoIncrement);
        this.recordMapper.alterTableIncrement(data);
    }

    @Override
    public void insertSelectiveRecord(MoneyTreeRewardRecord record) {
        this.recordMapper.insertSelective(record, this.getCurrentTableName());
    }

    @Override
    public MoneyTreeRewardRecord getClosetRecord(Long userId) {
        MoneyTreeRewardRecord record = this.recordMapper.getClosetTreeRecord(userId, this.getCurrentTableName());
        return record != null ? record : this.recordMapper.getClosetTreeRecord(userId, this.getLastTableName());
    }

    @Override
    public MoneyTreeRewardRecord getGatherRecord(Long userId) {
        return this.recordMapper.getGatherRecord(userId, this.getCurrentTableName());
    }

    @Override
    public void updateShareRewardState(Long id) {
        int i = this.recordMapper.updateShareRewardState(id, this.getCurrentTableName());
        if (i <= 0) {
            throw new BusinessException("\u66f4\u65b0\u5931\u8d25");
        }
    }
}

