/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.activity.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.activity.domain.MoneyTreeMapper;
import com.bxm.newidea.wanzhuan.activity.domain.MoneyTreeRewardConfigMapper;
import com.bxm.newidea.wanzhuan.activity.enums.TaskTypeEnum;
import com.bxm.newidea.wanzhuan.activity.service.MoneyTreeRewardRecordService;
import com.bxm.newidea.wanzhuan.activity.service.MoneyTreeService;
import com.bxm.newidea.wanzhuan.activity.vo.MoneyTree;
import com.bxm.newidea.wanzhuan.activity.vo.MoneyTreeRewardConfig;
import com.bxm.newidea.wanzhuan.activity.vo.MoneyTreeRewardRecord;
import com.bxm.newidea.wanzhuan.base.constant.AppConst;
import com.bxm.newidea.wanzhuan.base.service.ShortLinkService;
import com.bxm.newidea.wanzhuan.base.vo.ShortLinkReq;
import com.bxm.newidea.wanzhuan.points.service.PayFlowService;
import com.bxm.newidea.wanzhuan.points.vo.PayFlow;
import com.bxm.newidea.wanzhuan.security.service.UserService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="moneyTreeService")
public class MoneyTreeServiceImpl
implements MoneyTreeService {
    public static final int GENERATE_TREE_INTERVAL = 2;
    private static final int NOT_EXIST_GOLD = 0;
    private static final int EXIST_GOLD = 1;
    private static final String SHARE_TITLE = "\u597d\u53cb\u9080\u8bf7\u60a8\u6765\u73a9\u8d5a\u5934\u6761\u79cd\u6447\u94b1\u6811\u6323\u94b1\u4e86\uff01";
    private static final String SHARE_CONTENT = "\u6211\u5728\u73a9\u8d5a\u5934\u6761\u79cd\u4e86\u4e00\u68f5\u6447\u94b1\u6811\uff0c\u6210\u719f\u5c31\u80fd\u6536\u53d6\uff0c\u8d76\u5feb\u548c\u6211\u4e00\u8d77\u79cd\u6811\u5427,";
    @Resource
    private MoneyTreeMapper moneyTreeMapper;
    @Resource
    private MoneyTreeRewardConfigMapper moneyTreeRewardConfigMapper;
    @Resource
    private MoneyTreeRewardRecordService recordService;
    @Resource
    private PayFlowService payFlowService;
    @Resource
    private UserService userService;
    @Resource
    private ShortLinkService shortLinkService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisListAdapter redisListAdapter;

    @Override
    public Object getMoneyTreeState(Long userId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        MoneyTreeRewardRecord record = this.recordService.getClosetRecord(userId);
        boolean isTaked = this.isTaked2Hours(record);
        retMap.put("intervalTime", 2);
        retMap.put("treeId", 0);
        if (isTaked) {
            retMap.put("isExistGold", 0);
            retMap.put("nextTreeTime", DateUtils.addField((Date)record.getCreateTime(), (int)11, (int)2));
        } else {
            retMap.put("isExistGold", 1);
            retMap.put("remark", "\u6536\u53d6\u91d1\u5e01");
        }
        return ResultUtil.genSuccessResult(retMap);
    }

    private boolean isTaked2Hours(MoneyTreeRewardRecord record) {
        return record != null && this.checkIntervalRecord(record);
    }

    private boolean checkIntervalRecord(MoneyTreeRewardRecord record) {
        long intervalTime = 7200L;
        long time = (System.currentTimeMillis() - record.getCreateTime().getTime()) / 1000L;
        return time < intervalTime;
    }

    @Override
    public Object gatherMoneyTreeReward(Long userId, Long treeId) {
        MoneyTreeRewardRecord lastRecord = this.recordService.getClosetRecord(userId);
        boolean isTaked = this.isTaked2Hours(lastRecord);
        if (isTaked) {
            return ResultUtil.genFailedResult((String)"\u6682\u65f6\u4e0d\u80fd\u9886\u53d6\u91d1\u5e01");
        }
        long reward = this.calculateMoneyTreeReward(userId);
        MoneyTreeRewardRecord record = MoneyTreeRewardRecord.initRecord(treeId, userId, reward, (byte)10);
        this.recordService.insertSelectiveRecord(record);
        PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.MONEY_TREE.getType(), (Byte)10, (String)record.getId().toString());
        this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, new BigDecimal(reward), false);
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put("shareRemark", "\u5206\u4eab\u5230\u670b\u53cb\u5708\u518d\u8d5a18\u91d1\u5e01");
        retMap.put("rewardMsg", "\u606d\u559c\u83b7\u53d6" + reward + "\u91d1\u5e01");
        return ResultUtil.genSuccessResult(retMap);
    }

    private long calculateMoneyTreeReward(Long userId) {
        int userLevel = this.userService.getUserLevel(userId);
        List<MoneyTreeRewardConfig> configs = this.getMoneyRewardconfigInfo();
        for (MoneyTreeRewardConfig config : configs) {
            if (config.getLevel() != userLevel) continue;
            return this.getRandomRewardByLevel(config);
        }
        return 0L;
    }

    private List<MoneyTreeRewardConfig> getMoneyRewardconfigInfo() {
        RedisKeyGenerator key = RedisKeyGenerator.build((String)"moneyTreeConfig");
        String redisRet = (String)this.redisStringAdapter.get((KeyGenerator)key);
        if (StringUtils.isNotBlank((CharSequence)redisRet)) {
            return JSON.parseArray((String)redisRet, MoneyTreeRewardConfig.class);
        }
        List<MoneyTreeRewardConfig> list = this.moneyTreeRewardConfigMapper.listAll();
        this.redisStringAdapter.set((KeyGenerator)key, (Object)JSON.toJSONString(list), 604800L);
        return list;
    }

    private long getRandomRewardByLevel(MoneyTreeRewardConfig config) {
        return RandomUtils.nextLong((long)config.getLeast().intValue(), (long)config.getHight().intValue());
    }

    @Override
    public Object gatherShareReward(Long userId, Long treeId) {
        MoneyTreeRewardRecord record = this.recordService.getClosetRecord(userId);
        if (record == null) {
            return ResultUtil.genFailedResult((String)"\u83b7\u53d6\u5931\u8d25,\u65e0\u6447\u94b1\u6811\u9886\u53d6\u8bb0\u5f55");
        }
        if (record.getShareState().equals(MoneyTreeRewardRecord.SHARED)) {
            return ResultUtil.genFailedResult((String)"\u91d1\u5e01\u5df2\u7ecf\u9886\u5b8c\u4e86,\u8bf7\u7a0d\u540e\u518d\u9886");
        }
        PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.MEONEY_TREE_BY_SHARE.getType(), (Byte)10, (String)record.getId().toString());
        this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, AppConst.GOLD_NUM.MONEY_TREE_SHARE, false);
        this.recordService.updateShareRewardState(record.getId());
        return ResultUtil.genSuccessResult();
    }

    @Override
    public void quartzGenerateMoneyTree() {
        List<MoneyTree> treeList = this.moneyTreeMapper.selectQuartzClosestMoneyTree();
        if (this.notRequiredGenerate(treeList)) {
            return;
        }
        MoneyTree moneyTree = this.initMoneyTree(treeList != null && !treeList.isEmpty() ? treeList.get(0).getEndTime() : new Date());
        this.moneyTreeMapper.insertSelective(moneyTree);
        this.pushTreeToRedis(moneyTree);
    }

    @Override
    public Object getShareMessage(Long userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", SHARE_TITLE);
        map.put("content", SHARE_CONTENT);
        ShortLinkReq req = new ShortLinkReq();
        req.setType(Byte.valueOf((byte)1));
        req.setUserId(userId);
        Map m = this.shortLinkService.getRegisterShortUrl(req);
        map.putAll(m);
        return ResultUtil.genSuccessResult(map);
    }

    private boolean notRequiredGenerate(List<MoneyTree> treeList) {
        if (treeList != null && !treeList.isEmpty()) {
            if (treeList.size() >= 2) {
                return true;
            }
            Date startDate = DateUtils.addField((Date)new Date(), (int)11, (int)1);
            return startDate.compareTo(treeList.get(0).getEndTime()) <= 0;
        }
        return false;
    }

    private MoneyTree initMoneyTree(Date beginTime) {
        return new MoneyTree(beginTime, DateUtils.addField((Date)beginTime, (int)11, (int)2), (byte)10, new Date());
    }

    private void pushTreeToRedis(MoneyTree moneyTree) {
        RedisKeyGenerator key = RedisKeyGenerator.build((String)"moneyTree");
        this.redisListAdapter.leftPush((KeyGenerator)key, new Object[]{JSON.toJSONString((Object)moneyTree)});
        this.redisListAdapter.expire((KeyGenerator)key, 14400L);
    }
}

