/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.activity.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.activity.domain.DailyTaskMapper;
import com.bxm.newidea.wanzhuan.activity.domain.InviteRelationMapper;
import com.bxm.newidea.wanzhuan.activity.domain.NoviceTaskRecordMapper;
import com.bxm.newidea.wanzhuan.activity.enums.TaskTypeEnum;
import com.bxm.newidea.wanzhuan.activity.model.InviteRelation;
import com.bxm.newidea.wanzhuan.activity.model.InviteRelationVO;
import com.bxm.newidea.wanzhuan.activity.service.NoviceTaskRecordService;
import com.bxm.newidea.wanzhuan.activity.vo.DailyTask;
import com.bxm.newidea.wanzhuan.activity.vo.NoviceTaskRecord;
import com.bxm.newidea.wanzhuan.base.constant.RedisConfig;
import com.bxm.newidea.wanzhuan.points.service.PayFlowService;
import com.bxm.newidea.wanzhuan.points.service.UserRewardStatService;
import com.bxm.newidea.wanzhuan.points.vo.PayFlow;
import com.bxm.newidea.wanzhuan.points.vo.PrenticeStatModel;
import com.bxm.newidea.wanzhuan.security.model.UserAddressBook;
import com.bxm.newidea.wanzhuan.security.service.UserAddressBookService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="noviceTaskRecordService")
public class NoviceTaskRecordServiceImpl
implements NoviceTaskRecordService {
    private static final Logger log = LoggerFactory.getLogger(NoviceTaskRecordServiceImpl.class);
    @Resource
    private DailyTaskMapper dailyTaskMapper;
    @Resource
    private NoviceTaskRecordMapper noviceTaskRecordMapper;
    @Resource
    private PayFlowService payFlowService;
    @Resource
    private InviteRelationMapper inviteRelationMapper;
    @Resource
    private UserAddressBookService userAddressBookService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private UserRewardStatService userRewardStatService;

    public void batchAdd(long userId) {
        List<DailyTask> taskList = this.dailyTaskMapper.findSelectiveByType(DailyTask.NEWBIEW_TASK);
        if (null != taskList) {
            ArrayList<NoviceTaskRecord> recordList = new ArrayList<NoviceTaskRecord>();
            for (DailyTask task : taskList) {
                NoviceTaskRecord record = new NoviceTaskRecord();
                record.setTaskId(task.getId());
                record.setState((byte)0);
                record.setUserId(userId);
                recordList.add(record);
            }
            this.noviceTaskRecordMapper.batchAdd(recordList);
        }
    }

    public void updateUserNoviceTask(long userId, long taskId) {
        NoviceTaskRecord record = this.noviceTaskRecordMapper.findSelectiveByType(taskId, userId);
        if (null != record && 0 == record.getState()) {
            DailyTask dailyTask;
            record.setState((byte)1);
            this.noviceTaskRecordMapper.updateByPrimaryKeySelective(record);
            log.info("\u65b0\u624b\u4efb\u52a1\u5b8c\u6210,taskId=" + taskId + ",userId=" + userId);
            if ((long)TaskTypeEnum.BIND_WEIXIN.getType() == taskId && null != (dailyTask = this.dailyTaskMapper.selectByPrimaryKey(record.getTaskId()))) {
                PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.BIND_WEIXIN.getType(), (Byte)dailyTask.getRewardType(), (String)record.getId().toString());
                this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, dailyTask.getReward(), false);
            }
        }
    }

    public Object openingNotice(Long userId) {
        String key = "openingNotice_" + userId;
        if (this.redisStringAdapter.hasKey((KeyGenerator)RedisKeyGenerator.build((String)key))) {
            return ResultUtil.genSuccessMsg();
        }
        this.redisStringAdapter.set((KeyGenerator)RedisKeyGenerator.build((String)key), (Object)userId.toString(), 3L);
        long taskId = TaskTypeEnum.PUSH_NEWS_OPEN.getType();
        NoviceTaskRecord record = this.noviceTaskRecordMapper.findSelectiveByType(taskId, userId);
        if (null != record && 0 == record.getState()) {
            DailyTask dailyTask = this.dailyTaskMapper.selectByPrimaryKey(record.getTaskId());
            if (null != dailyTask) {
                PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.PUSH_NEWS_OPEN.getType(), (Byte)dailyTask.getRewardType(), (String)record.getId().toString());
                this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, dailyTask.getReward(), false);
            }
            record.setState((byte)1);
            this.noviceTaskRecordMapper.updateByPrimaryKeySelective(record);
        }
        return ResultUtil.genSuccessMsg();
    }

    public Object getAddressBook(long userId, List<UserAddressBook> bookList) {
        String prenticeDaily;
        String result;
        long taskId;
        NoviceTaskRecord record;
        List<InviteRelationVO> voList = this.inviteRelationMapper.getInviteRelationVO(userId);
        if (null != voList) {
            block0: for (InviteRelationVO vo : voList) {
                for (UserAddressBook book : bookList) {
                    if (!vo.getPhone().equals(book.getPhone())) continue;
                    InviteRelation inviteRelation = new InviteRelation();
                    inviteRelation.setId(vo.getId());
                    inviteRelation.setNickname(book.getName());
                    this.inviteRelationMapper.updateByPrimaryKeySelective(inviteRelation);
                    book.setUserId(Long.valueOf(userId));
                    this.userAddressBookService.addUserAddressBook(book);
                    continue block0;
                }
            }
        }
        if (null != (record = this.noviceTaskRecordMapper.findSelectiveByType(taskId = (long)TaskTypeEnum.MATCHES_CONTACTS.getType(), userId)) && 0 == record.getState()) {
            DailyTask dailyTask = this.dailyTaskMapper.selectByPrimaryKey(record.getTaskId());
            if (null != dailyTask) {
                PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.MATCHES_CONTACTS.getType(), (Byte)dailyTask.getRewardType(), (String)record.getId().toString());
                this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, dailyTask.getReward(), false);
            }
            record.setState((byte)1);
            this.noviceTaskRecordMapper.updateByPrimaryKeySelective(record);
        }
        if (StringUtils.isNotBlank((CharSequence)(result = (String)this.redisStringAdapter.get((KeyGenerator)RedisKeyGenerator.build((String)(prenticeDaily = RedisConfig.RewardStat.REWARD_PRENTICE + ":" + userId)))))) {
            PrenticeStatModel statModel = (PrenticeStatModel)JSON.parseObject((String)result, PrenticeStatModel.class);
            statModel.setPrenticeList(this.userRewardStatService.getPrenticesInfo(Long.valueOf(userId)));
            this.redisStringAdapter.set((KeyGenerator)RedisKeyGenerator.build((String)prenticeDaily), (Object)JSON.toJSONString((Object)statModel), 600L);
        }
        return ResultUtil.genSuccessMsg((String)"\u5339\u914d\u6210\u529f");
    }
}

