/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.activity.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.activity.domain.SignConfigMapper;
import com.bxm.newidea.wanzhuan.activity.domain.SignRecordMapper;
import com.bxm.newidea.wanzhuan.activity.enums.TaskTypeEnum;
import com.bxm.newidea.wanzhuan.activity.service.SignService;
import com.bxm.newidea.wanzhuan.activity.vo.SignConfig;
import com.bxm.newidea.wanzhuan.activity.vo.SignRecord;
import com.bxm.newidea.wanzhuan.base.exception.BusinessException;
import com.bxm.newidea.wanzhuan.points.service.PayFlowService;
import com.bxm.newidea.wanzhuan.points.vo.PayFlow;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SignServiceImpl
implements SignService {
    private static final String INIT_TABLE_NAME = "b_sign_record";
    @Resource
    private SignConfigMapper signConfigMapper;
    @Resource
    private SignRecordMapper signRecordMapper;
    @Resource
    private PayFlowService payFlowService;
    @Resource
    private RedisStringAdapter redisStringAdapter;

    private String getSignTableName(Long userId) {
        return "b_sign_record_" + userId.toString().substring(userId.toString().length() - 1);
    }

    @Override
    public Object listSignRecord(Long userId) {
        Date signDate;
        int lastSign;
        List<SignRecord> signRecords = this.listUserSignRecord(userId);
        if (signRecords != null && !signRecords.isEmpty() && (lastSign = Math.abs(DateUtils.getDiffDays((Date)new Date(), (Date)(signDate = signRecords.get(0).getSignDate())))) != 1 && lastSign != 0) {
            signRecords.get(0).setSignDay(0);
        }
        return ResultUtil.genSuccessResult(signRecords);
    }

    @Override
    public Object dailySign(Long userId) {
        List<SignRecord> userRecordList = this.listUserSignRecord(userId);
        SignRecord lastRecord = this.checkLastSignRecord(userRecordList);
        long reward = this.acquireSignReword(lastRecord);
        SignRecord signRecord = this.saveSignRecord(userId, reward, lastRecord);
        PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.SIGN_DAILY.getType(), (Byte)10, (String)signRecord.getId().toString());
        this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, new BigDecimal(reward), false);
        this.updateRedisRecord(userRecordList, userId, signRecord);
        HashMap m = Maps.newHashMap();
        m.put("reward", reward);
        return ResultUtil.genSuccessResult((Object)m);
    }

    private List<SignRecord> listUserSignRecord(Long userId) {
        RedisKeyGenerator key = RedisKeyGenerator.build((String)("signRecord:" + userId));
        String redisRet = (String)this.redisStringAdapter.get((KeyGenerator)key);
        if (StringUtils.isNotBlank((CharSequence)redisRet)) {
            return JSON.parseArray((String)redisRet, SignRecord.class);
        }
        List<SignRecord> recordList = this.signRecordMapper.listUserSignRecord(userId, this.getSignTableName(userId));
        this.redisStringAdapter.set((KeyGenerator)key, (Object)JSON.toJSONString(recordList), 604800L);
        return recordList;
    }

    private SignRecord checkLastSignRecord(List<SignRecord> userRecordList) {
        if (userRecordList == null || userRecordList.isEmpty()) {
            SignRecord lastRecord = new SignRecord();
            lastRecord.setSignDate(new Date());
            lastRecord.setSignDay(1);
            return lastRecord;
        }
        SignRecord lastRecord = userRecordList.get(0);
        if (DateUtils.getDiffDays((Date)lastRecord.getSignDate(), (Date)new Date()) == 0) {
            throw new BusinessException("\u4eca\u65e5\u5df2\u7b7e\u5230");
        }
        return lastRecord;
    }

    private long acquireSignReword(SignRecord lastRecord) {
        List<SignConfig> configList = this.getSignconfigInfo();
        int daysBetweenLastSign = DateUtils.getDiffDays((Date)lastRecord.getSignDate(), (Date)new Date());
        if (daysBetweenLastSign == 0 || daysBetweenLastSign > 1) {
            return this.calculateSignReward(1, configList);
        }
        return this.calculateSignReward(lastRecord.getSignDay() + 1, configList);
    }

    private List<SignConfig> getSignconfigInfo() {
        RedisKeyGenerator key = RedisKeyGenerator.build((String)"signConfig");
        String redisRet = (String)this.redisStringAdapter.get((KeyGenerator)key);
        if (StringUtils.isNotBlank((CharSequence)redisRet)) {
            return JSON.parseArray((String)redisRet, SignConfig.class);
        }
        List<SignConfig> list = this.signConfigMapper.listAll();
        this.redisStringAdapter.set((KeyGenerator)key, (Object)JSON.toJSONString(list), 604800L);
        return list;
    }

    private long calculateSignReward(int continiousDay, List<SignConfig> configList) {
        for (SignConfig signConfig : configList) {
            if (signConfig.getDate() != continiousDay) continue;
            return signConfig.getReward();
        }
        return configList.get(configList.size() - 1).getReward();
    }

    private SignRecord saveSignRecord(Long userId, long reward, SignRecord lastRecord) {
        SignRecord signRecord = new SignRecord(userId, new Date(), reward);
        int daysBetweenLastSign = DateUtils.getDiffDays((Date)lastRecord.getSignDate(), (Date)new Date());
        if (daysBetweenLastSign == 0 || daysBetweenLastSign > 1) {
            signRecord.setSignDay(1);
        } else {
            signRecord.setSignDay(lastRecord.getSignDay() + 1);
        }
        this.signRecordMapper.insertSelective(signRecord, this.getSignTableName(userId));
        return signRecord;
    }

    private void updateRedisRecord(List<SignRecord> userRecordList, Long userId, SignRecord signRecord) {
        userRecordList.add(signRecord);
        userRecordList.sort((o1, o2) -> o2.getSignDate().compareTo(o1.getSignDate()));
        this.redisStringAdapter.set((KeyGenerator)RedisKeyGenerator.build((String)("signRecord:" + userId)), (Object)JSON.toJSONString(userRecordList), 604800L);
    }
}

