package com.bxm.newidea.wanzhuan.advertisement.controller;

import com.bxm.newidea.common.util.NidGeneratorUtil;
import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.common.util.UploadImgUtil;
import com.bxm.newidea.common.vo.UploadFileRes;
import com.bxm.newidea.wanzhuan.advertisement.domain.AdvertMapper;
import com.bxm.newidea.wanzhuan.advertisement.enums.AdvertTypeEnum;
import com.bxm.newidea.wanzhuan.advertisement.model.Advert;
import com.bxm.newidea.wanzhuan.advertisement.model.AdvertDTO;
import com.bxm.newidea.wanzhuan.base.vo.Json;
import com.bxm.newidea.wanzhuan.base.vo.RdPage;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.*;

@RestController
@RequestMapping("api/admin/advert")
public class AdminAdvertController {

    private final static String ADVERT = "advert";

    private final static String ACTIVITY = "activity";

    @Resource
    private AdvertMapper advertMapper;


    @RequestMapping("/list")
    @RequiresPermissions("admin:advert")
    public Json<List<Advert>> getAdvert(AdvertDTO advertDTO) {
        RdPage rdPage = new RdPage();
        rdPage.setCurPage(advertDTO.getCurPage());
        rdPage.setPageSize(advertDTO.getPageSize());
        rdPage.setItemTotal(this.advertMapper.getAdvertCount(advertDTO));

        List<String> codeList = this.advertMapper.getCodeList(advertDTO);

        List<Advert> advertList = new ArrayList<>();

        for (String aCodeList : codeList) {
            Map<String, Advert> param = new LinkedHashMap<>();
            List<Advert> advertList1 = this.advertMapper.getAdvertListByCode(aCodeList);
            for (Advert advert : advertList1) {
                String key = advert.getCode();
                if (param.containsKey(key)) {
                    Advert stu = param.get(key);
                    List<String> type = this.advertMapper.getTypeByCode(stu.getCode());
                    String s = StringUtils.join(type.toArray(), ",");
                    advert.setType(s);
                }
                param.put(key, advert);
            }
            advertList1.clear();
            advertList1.addAll(param.values());
            advertList.addAll(advertList1);
        }

        for (Advert advert : advertList) {
            List<String> typeList = new ArrayList<>();
            String[] array = advert.getType().split(",");
            if (array.length == 1) {
                advert.setType(AdvertTypeEnum.getAdvertTypeEnum(advert.getType()));
            } else {
                for (String anArray : array) {
                    typeList.add(AdvertTypeEnum.getAdvertTypeEnum(anArray));
                }
                String ss = StringUtils.join(typeList.toArray(), ",");
                advert.setType(ss);
            }
        }

        return ResultUtil.genSuccessResultWithPage(advertList, rdPage);
    }

    @ApiOperation("广告上下架")
    @RequestMapping("/updateAdverts")
    @RequiresPermissions("admin:advert")
    public Object updateAdvertStatusById(String code, Byte status) {
        List<Advert> advertList = this.advertMapper.getAdvertListByCode(code);
        int flag = 0;
        for (Advert newadvert : advertList) {
            Advert advert = new Advert();
            advert.setId(newadvert.getId());
            advert.setStatus(status);
            flag = this.advertMapper.updateByPrimaryKeySelective(advert);
        }
        if (flag > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    //广告批量上下架
    @RequestMapping("/batchUpdateAdverts")
    @RequiresPermissions("admin:advert")
    public Object updateAdvertStatusByIds(String codes, Byte status) {
        String idsNew = codes.substring(1, codes.length() - 1);
        String idsNews = idsNew.replace("\"", "");
        String code[] = idsNews.split(",");
        if (code != null && code.length > 0) {
            int flag = this.advertMapper.updateAdvertStatusByCodes(code, status);
            if (flag > 0) {
                return ResultUtil.genSuccessMsg("更新成功");
            }
            return ResultUtil.genFailedResult("更新失败");
        } else {
            return ResultUtil.genFailedResult("请选择新闻");
        }
    }

    //广告详情 todo 头像 源地址
    @RequestMapping("/getAdvertsDetail")
    @RequiresPermissions("admin:advert")
    public Object getAdvertDetail(String code) {
        return ResultUtil.genSuccessResult(this.advertMapper.getAdvertListByCode(code));
    }


    //新增广告
    @RequestMapping("/saveOrUpdateAdverts")
    @RequiresPermissions("admin:advert")
    public Object addAdvertDetail(Advert advert) {
        int flag = 0;
        if (advert.getId() != null) {
            this.advertMapper.deleteByCode(advert.getCode());
        }
        String code = NidGeneratorUtil.getCodeNo("gg");
        String[] type = advert.getType().split(",");
        String[] imgUrl = advert.getImgUrl().split(",");
        for (int i = 0; i < type.length; i++) {
            Advert newAdvert = new Advert();
            newAdvert.setTitle(advert.getTitle());
            newAdvert.setAuthor(advert.getAuthor());
            newAdvert.setAddress(advert.getAddress());
            newAdvert.setAuthorImg(advert.getAuthorImg());
            newAdvert.setImgUrl(imgUrl[i]);
            newAdvert.setLabel(advert.getLabel());
            newAdvert.setType(type[i]);
            newAdvert.setStatus(advert.getStatus());
            newAdvert.setCode(code);
            newAdvert.setSendType(advert.getSendType());
            if ("0".equals(advert.getSendType())) {
                newAdvert.setStatus(Byte.valueOf("1"));
                newAdvert.setSendTime(new Date());
            } else {
                newAdvert.setStatus(Byte.valueOf("2"));
                newAdvert.setSendTime(advert.getSendTime());
            }
            flag = this.advertMapper.insertSelective(newAdvert);
        }
        if (flag <= 0) {
            return ResultUtil.genFailedResult("更新失败");
        }
        return ResultUtil.genSuccessMsg("更新成功");
    }

    /**
     * 图片上传
     */
    @RequestMapping(value = "upload/img")
    @ResponseBody
    public Object uploadImg(MultipartFile file, String type) {
        String s = this.saveAdvertImg(file, type);
        if (s == null) {
            return ResultUtil.genFailedResult("图片上传失败");
        }
        return ResultUtil.genSuccessResult(s);
    }

    private String saveAdvertImg(MultipartFile file, String type) {
        if (file != null && !file.isEmpty()) {
            String picName = null;
            String filePath = null;
            if ("1".equals(type)) {
                picName = ADVERT + "_" + file.getOriginalFilename();
                filePath = "toutiao/advert/img/" + picName;
            } else if ("2".equals(type)) {
                picName = ACTIVITY + "_" + file.getOriginalFilename();
                filePath = "toutiao/activity/img/" + picName;
            }
            UploadFileRes model = UploadImgUtil.save(file, picName, filePath);
            return model.getResPath();
        }
        return null;
    }
}
