package com.bxm.newidea.wanzhuan.advertisement.controller;


import com.bxm.newidea.common.util.PageHelperUtil;
import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.common.util.UploadImgUtil;
import com.bxm.newidea.common.vo.UploadFileRes;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.wanzhuan.advertisement.service.BannerService;
import com.bxm.newidea.wanzhuan.advertisement.vo.Banner;
import com.github.pagehelper.Page;
import com.google.common.collect.Maps;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/12/26.
 */
@Controller
@RequestMapping("api/admin/banner")
public class AdminBannerController extends BaseController {

    private final static Logger logger = LoggerFactory.getLogger(BannerController.class);

    private final static String BANNER = "banner";

    @Resource
    private BannerService bannerService;

    /**
     * 功能区列表
     */
    @RequestMapping(value = "bannerList")
    @ResponseBody
    @RequiresPermissions("admin:banner")
    public Object queryPayList(String name, String type,
                               @RequestParam(value = "curPage", required = true) int curPage,
                               @RequestParam(value = "pageSize", required = true) int pageSize) {
        Map<String, Object> searchMap = Maps.newHashMap();
        searchMap.put("name", name);
        searchMap.put("type", type);
        List<Banner> banners = this.bannerService.listBanner(searchMap, curPage, pageSize);
        return ResultUtil.genSuccessResult(PageHelperUtil.getPageData((Page<Banner>) banners));
    }

    /**
     * 新增和编辑功能功能
     */
    @RequestMapping(value = "saveOrUpdate")
    @ResponseBody
    @RequiresPermissions("admin:banner")
    public Object saveOrUpdate(Banner Banner, Integer functionId) {
        if (Banner.getId() == null) {
            return this.bannerService.insertSelective(Banner, functionId);
        } else {
            return this.bannerService.updateBySelective(Banner, functionId);
        }
    }

    /**
     * 图片上传
     */
    @RequestMapping(value = "upload/img")
    @ResponseBody
    public Object uploadImg(MultipartFile file) {
        String s = this.saveBannerImg(file);
        if (s == null) {
            return ResultUtil.genFailedResult("图片上传失败");
        }
        return ResultUtil.genSuccessResult(s);
    }

    private String saveBannerImg(MultipartFile file) {
        if (file != null && !file.isEmpty()) {
            String picName = BANNER + "_" + file.getOriginalFilename();
            String filePath = "toutiao/banner/img/" + picName;
            UploadFileRes model = UploadImgUtil.save(file, picName, filePath);
            return model.getResPath();
        }
        return null;
    }

    /**
     * 启用和禁用功能
     */
    @RequestMapping(value = "changState")
    @ResponseBody
    @RequiresPermissions("admin:banner")
    public Object changState(@RequestParam("bannerId") Long bannerId,
                             @RequestParam("state") String status) {
        return this.bannerService.changeState(bannerId, status);
    }


    //广告位批量上下架
    @RequestMapping("/batchUpdateBanner")
    public Object updateNewsStatusByIds(Long[] ids, Byte status) {
        if (ids != null && ids.length > 0) {
            int flag = this.bannerService.updateBannerStatusByIds(ids, status);
            if (flag > 0) {
                return ResultUtil.genSuccessMsg("更新成功");
            }
            return ResultUtil.genFailedResult("更新失败");
        } else {
            return ResultUtil.genFailedResult("请选择广告");
        }
    }


    /**
     * 查看广告位信息
     */
    @RequestMapping(value = "getBannerInfo")
    @ResponseBody
    public Object getBannerInfo(@RequestParam("bannerId") int bannerId) {
        return ResultUtil.genSuccessResult(this.bannerService.getBanner(bannerId));
    }


}
