package com.bxm.newidea.wanzhuan.advertisement.controller;

import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.wanzhuan.advertisement.domain.AdvertMapper;
import com.bxm.newidea.wanzhuan.advertisement.domain.AdvertStatisticMapper;
import com.bxm.newidea.wanzhuan.advertisement.model.Advert;
import com.bxm.newidea.wanzhuan.base.constant.ErrorCode;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * Created by hsq 17:37 2018/5/23
 */
@RestController
@RequestMapping("api/advert")
public class AdvertController {

    @Resource
    private AdvertStatisticMapper advertStatisticMapper;

    @Resource
    private AdvertMapper advertMapper;

    /**
     * 点击广告
     * @param advertId
     * @return
     */
    @RequestMapping(value = "click", method = RequestMethod.POST)
    public Object addClicks(Long advertId) {
        Advert advert = this.advertMapper.selectByPrimaryKey(advertId);
        if (advert != null) {
            this.advertStatisticMapper.addClicks(advertId);
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult(ErrorCode.PARAM_ERR, "广告不存在");
    }

    /**
     * 广告展示出来
     * @param advertId
     * @return
     */
    @RequestMapping(value = "show", method = RequestMethod.POST)
    public Object addShows(Long advertId) {
        Advert advert = this.advertMapper.selectByPrimaryKey(advertId);
        if (advert != null) {
            this.advertStatisticMapper.addShows(advertId);
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult(ErrorCode.PARAM_ERR, "广告不存在");
    }
}
