package com.bxm.newidea.wanzhuan.advertisement.controller;

import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.wanzhuan.advertisement.enums.BannerEunm;
import com.bxm.newidea.wanzhuan.advertisement.model.Advert;
import com.bxm.newidea.wanzhuan.advertisement.service.AdvertService;
import com.bxm.newidea.wanzhuan.advertisement.service.BannerService;
import com.bxm.newidea.wanzhuan.base.constant.RedisContents;
import com.bxm.newidea.wanzhuan.base.service.SysConfigRedis;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * Created by Administrator on 2018/2/7 0007.
 */
@RequestMapping("/api")
@RestController
public class BannerController {


    @Resource
    private transient BannerService bannerService;

    @Resource
    private transient AdvertService advertService;

    @Resource
    private SysConfigRedis sysConfigRedis;


    /**
     * 获取广告位信息
     * @Date:2018/2/24 0024
     * @Author:lwk
     */
    @RequestMapping(value = "advert/query", method = RequestMethod.GET)
    public Object getAdverts(@RequestParam(value = "type", required = true) Byte type) {
        List<Advert> data = new ArrayList<>(3);
        List<Advert> list = this.advertService.queryAdByType(type);
        Random random = new Random();
        if (type.equals(BannerEunm.MYMESSAGE_AD.getType()) || type.equals(BannerEunm.SUSPEND_AD.getType())) {
            if (!ObjectUtils.isEmpty(list)) {
                Advert advert = list.get(random.nextInt(list.size()));
                data.add(advert);
                return ResultUtil.genSuccessResult(data);
            }
        } else if (type.equals(BannerEunm.POPUP_AD.getType())) {
            int adSwitch = this.sysConfigRedis.getInt(RedisContents.TYPE.SYSTEM, "popup_ad");
            if (RedisContents.POPUP_AD_ON == adSwitch) {
                if (!ObjectUtils.isEmpty(list)) {
                    Advert advert = list.get(random.nextInt(list.size()));
                    data.add(advert);
                    return ResultUtil.genSuccessResult(data);
                }
            }
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genSuccessResult(list);
    }

}

