package com.bxm.newidea.wanzhuan.security.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "登录请求参数")
public class LoginInfo extends User {

    @ApiModelProperty("登录标识,如果是手机号密码则传递手机号码，如果是第三方登录则传递第三方登录标识")
    private String loginName;

    @ApiModelProperty("手机验证码")
    private String code;

    @ApiModelProperty("登录类型,1:手机号、密码登录，2：QQ登录，3：微信登录，4：微博登录")
    private Byte type;

    @ApiModelProperty("邀请码")
    private Long inviteCode;

    @ApiModelProperty("手机型号")
    private String phonemodel;

    @ApiModelProperty("注册地址")
    private String registeredaddress;

    @ApiModelProperty("登录密码")
    private String password;

    @ApiModelProperty("如果当前登录请求属于忘记密码并登录则设置为true")
    private Boolean resetPwd;

    @ApiModelProperty("注册渠道，0：APP内注册、1：红包分享注册")
    private Byte regChannel;

    public Byte getRegChannel() {
        return regChannel;
    }

    public void setRegChannel(Byte regChannel) {
        this.regChannel = regChannel;
    }

    public Boolean getResetPwd() {
        return this.resetPwd;
    }

    public void setResetPwd(Boolean resetPwd) {
        this.resetPwd = resetPwd;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Long getInviteCode() {
        return this.inviteCode;
    }

    public void setInviteCode(Long inviteCode) {
        this.inviteCode = inviteCode;
    }

    public String getPhonemodel() {
        return this.phonemodel;
    }

    public void setPhonemodel(String phonemodel) {
        this.phonemodel = phonemodel;
    }

    public String getRegisteredaddress() {
        return this.registeredaddress;
    }

    public void setRegisteredaddress(String registeredaddress) {
        this.registeredaddress = registeredaddress;
    }

    @Override
    public String toString() {
        return "LoginInfo{" +
                "loginName='" + this.loginName + '\'' +
                ", code='" + this.code + '\'' +
                ", type=" + this.type +
                ", inviteCode=" + this.inviteCode +
                ", phonemodel='" + this.phonemodel + '\'' +
                ", registeredaddress='" + this.registeredaddress + '\'' +
                ", password='" + this.password + '\'' +
                ", resetPwd=" + this.resetPwd +
                '}';
    }
}
