package com.bxm.op.sms.facade.model.dto;

import lombok.Data;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 短信对象
 *
 * @author daill
 * @date 2024/06/28
 */
@Data
public class CommonSmsDto implements Serializable {
    /**
     * 运营商类型
     */
    @NotBlank(message = "运营商不能为空")
    private String opType;
    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    private String mobile;
    /**
     * 运营商配置
     */
    private String opConfig;
    /**
     * ip
     */
    private String ip;
    /**
     * ua
     */
    private String ua;
    /**
     * uid
     */
    private String uid;
    /**
     * 券id
     */
    private Integer ticketId;
    /**
     * bxmid
     */
    private String bxmId;
    /**
     * 广告位id
     */
    private String positionId;
    /**
     * 当前页面的url
     */
    private String ticketUrl;
    /**
     * 扩展参数
     */
    private String ext;
    /**
     * 重新跳转链接
     */
    private String redirectUrl;
    /**
     * 发送到openLog的链接
     */
    private String openLogUrl;
    /**
     * 胜出的bxmId
     */
    private String winBxmId;
    /**
     * 手机号所属运营商信息
     */
    private MobileOpDto mobileOp;

    public String getWinBxmId() {
        return StringUtils.isEmpty(winBxmId) ? bxmId : winBxmId;
    }
}
