package com.bxm.op.sms.facade.model.vo;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * @author tangxiao
 * @date 2024/7/10
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class CommonSmsVo {
    /**
     * 跳转链接
     */
    private String jumpUrl;

    /**
     * 是否跳转 1跳转 0不跳转
     */
    private Integer jumpType = 0;

    /**
     * 扩展参数
     */
    private String ext;

    /**
     * 是否成功 供后端使用 需要设置
     */
    private boolean success;

    /**
     * 接口返回的消息 供埋点使用
     * 需要设置
     */
    private String msg;

    public boolean canJump() {
        return Objects.equals(jumpType, 1) && !StringUtils.isEmpty(jumpUrl);
    }

}
