package com.bxm.op.sms.facade.model.vo;


import java.io.Serializable;

/**
 * @author zhangdong
 * @date 2024/7/19
 */
public class ResponseVo<T> implements Serializable {
    private static final long serialVersionUID = 8107448352824904837L;
    /**
     * 返回的数据
     */
    private T data;
    /**
     * 是否成功
     */
    private boolean success = true;
    /**
     * 返回码
     */
    private Integer code = 1;
    /**
     * 消息
     */
    private String message = "成功";

    public static <T> ResponseVo<T> success(T data) {
        ResponseVo<T> vo = new ResponseVo<>();
        vo.setData(data);
        return vo;
    }

    public static <T> ResponseVo<T> fail(Integer code, String message) {
        ResponseVo<T> vo = new ResponseVo<>();
        vo.setSuccess(false);
        vo.setCode(code);
        vo.setMessage(message);
        return vo;
    }

    public static <T> ResponseVo<T> fail(String message) {
        return fail(0, message);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}

