package com.bxm.op.sms.facade.service;

import com.bxm.op.sms.facade.constants.FacadeConstants;
import com.bxm.op.sms.facade.model.dto.SendSmsDto;
import com.bxm.op.sms.facade.model.dto.UpdateBxmIdDto;
import com.bxm.op.sms.facade.model.dto.VerifySmsSimpleDto;
import com.bxm.op.sms.facade.model.vo.CommonSmsVo;
import com.bxm.op.sms.facade.model.vo.ResponseVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author zhangdong
 * @date 2024/7/18
 */
@FeignClient(name = FacadeConstants.SERVER_NAME)
public interface SmsFacadeService {


     /**
      * 发送验证码
      * @param dto
      * @return
      */
     @PostMapping("/facade/sms/sendSmsCaptchaByStrategy")
     ResponseVo<CommonSmsVo> sendSmsCaptchaByStrategy(@RequestBody @Validated SendSmsDto dto);

     /**
      * 验证验证码
      * @param dto
      * @return
      */
     @PostMapping("/facade/sms/verifySmsCaptchaBySimpleStrategy")
     ResponseVo<CommonSmsVo> verifySmsCaptchaSimpleByStrategy(@RequestBody @Validated VerifySmsSimpleDto dto);

     /**
      * 更新bxmId
      * @param dto
      */
     @PostMapping("/facade/sms/updateBxmId")
     void updateBxmId(@RequestBody @Validated UpdateBxmIdDto dto);
}
