/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.extension.client.ws;

import com.bxm.openlog.extension.client.Fallback;
import com.bxm.openlog.extension.client.HttpMethod;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.extension.client.ws.WsOpenLogClientHandler;
import com.bxm.openlog.extension.client.ws.WsOpenLogClientProperties;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnProperty(value={"openlog.ws.enable"}, havingValue="true")
@EnableConfigurationProperties(value={WsOpenLogClientProperties.class})
public class WsOpenLogClient
implements OpenLogClient {
    private static final Logger log = LoggerFactory.getLogger(WsOpenLogClient.class);
    private Timer timer;
    private Counter success;
    private Counter fail;
    private final ThreadPoolExecutor executor;
    private final AtomicInteger count = new AtomicInteger(0);
    private final List<WsOpenLogClientHandler> handlers = new ArrayList<WsOpenLogClientHandler>();

    public WsOpenLogClient(WsOpenLogClientProperties properties) {
        Integer socketSize = properties.getSocketSize();
        Preconditions.checkNotNull((Object)socketSize, (Object)"socketSize must be not null");
        Preconditions.checkArgument((socketSize > 0 ? 1 : 0) != 0, (Object)"socketSize must be greater than 0");
        WsOpenLogClientProperties.ThreadPoolConfig threadPoolConfig = properties.getThreadPoolConfig();
        for (int i = 0; i < socketSize; ++i) {
            this.handlers.add(new WsOpenLogClientHandler(properties));
        }
        this.executor = new ThreadPoolExecutor((int)threadPoolConfig.getCoreSize(), (int)threadPoolConfig.getMaxSize(), (long)threadPoolConfig.getKeepAlive().intValue(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(threadPoolConfig.getQueueSize()), (ThreadFactory)new NamedThreadFactory(threadPoolConfig.getThreadPrefix()));
    }

    public void bindTo(MeterRegistry registry) {
        Gauge.builder((String)"ws.openLogClient.queue", (Object)0, value -> this.queueSize()).register(registry);
        this.timer = Timer.builder((String)"ws.openLogClient.timer").register(registry);
        this.success = Counter.builder((String)"ws.openLogClient.counter").tag("name", "success").register(registry);
        this.fail = Counter.builder((String)"ws.openLogClient.counter").tag("name", "fail").register(registry);
    }

    public String parseUrl(String url) {
        String[] split;
        String productParamName;
        UriComponents build = UriComponentsBuilder.fromUriString((String)url).build();
        String path = build.getPath();
        String query = build.getQuery();
        MultiValueMap queryParams = build.getQueryParams();
        if (queryParams.containsKey((Object)(productParamName = "p"))) {
            return query;
        }
        String p = "";
        if (path != null && path.contains("/") && (split = path.split("/")).length > 1) {
            p = split[1];
        }
        return productParamName + "=" + p + "&" + query;
    }

    @Override
    public boolean request(String url) throws IOException {
        long start = System.nanoTime();
        String query = this.parseUrl(url);
        try {
            WsOpenLogClientHandler handler = this.handlers.get(Math.abs(this.count.addAndGet(1)) % this.handlers.size());
            handler.sendMessage(query);
            this.success.increment();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.fail.increment();
            throw new IOException();
        }
        finally {
            if (Objects.nonNull(this.timer)) {
                this.timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
    }

    @Override
    public boolean request(String url, HttpMethod httpMethod) throws IOException {
        return this.request(url);
    }

    @Override
    public void asyncRequest(String url, Consumer<Fallback> fallback) {
        this.executor.execute(() -> {
            block3: {
                try {
                    if (!this.request(url) && Objects.nonNull(fallback)) {
                        fallback.accept(Fallback.builder().url(url).build());
                    }
                }
                catch (IOException e) {
                    if (!Objects.nonNull(fallback)) break block3;
                    fallback.accept(Fallback.builder().url(url).exception(e).build());
                }
            }
        });
    }

    @Override
    public void asyncRequest(String url, Consumer<Fallback> fallback, HttpMethod httpMethod) {
        this.asyncRequest(url, fallback);
    }

    @Override
    public void asyncRequest(String url) {
        this.asyncRequest(url, HttpMethod.GET);
    }

    @Override
    public void asyncRequest(String url, HttpMethod httpMethod) {
        this.asyncRequest(url, null, httpMethod);
    }

    @Override
    public int queueSize() {
        return this.executor.getQueue().size();
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                log.warn("This executor was forced terminated!");
            }
        }
        catch (InterruptedException e) {
            log.error("awaitTermination: ", (Throwable)e);
        }
    }
}

