/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.extension.client.ws;

import com.bxm.openlog.extension.client.ws.WsOpenLogClientProperties;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PingMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.WebSocketConnectionManager;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class WsOpenLogClientHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(WsOpenLogClientHandler.class);
    private WebSocketSession session;
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(1);
    private final List<CloseStatus> reConnectionStatus = Lists.newArrayList((Object[])new CloseStatus[]{CloseStatus.NOT_ACCEPTABLE, CloseStatus.BAD_DATA, CloseStatus.SERVER_ERROR, CloseStatus.TOO_BIG_TO_PROCESS, CloseStatus.SERVICE_OVERLOAD});
    private final WsOpenLogClientProperties properties;
    private final WebSocketConnectionManager manager;

    public WsOpenLogClientHandler(WsOpenLogClientProperties properties) {
        this.properties = properties;
        String endpoint = properties.getEndpoint();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)endpoint), (Object)"endpoint is null or empty");
        StandardWebSocketClient socketClient = new StandardWebSocketClient();
        WebSocketConnectionManager manager = new WebSocketConnectionManager((WebSocketClient)socketClient, (WebSocketHandler)this, endpoint, new Object[0]);
        manager.start();
        this.manager = manager;
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.session = new ConcurrentWebSocketSessionDecorator(session, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.startHeartbeat();
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        if (this.reConnectionStatus.contains(status)) {
            int failSize = 0;
            while (failSize < 3) {
                try {
                    this.manager.stop();
                    this.scheduler.shutdownNow();
                    this.manager.start();
                    return;
                }
                catch (Exception e) {
                    log.error("reConnection error count:{}", (Object)(++failSize), (Object)e);
                }
            }
            throw new RuntimeException("reConnection error");
        }
    }

    public void sendMessage(String data) throws Exception {
        this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)data));
    }

    private void startHeartbeat() {
        this.scheduler.scheduleAtFixedRate(() -> {
            if (this.session != null && this.session.isOpen()) {
                try {
                    PingMessage pingMessage = new PingMessage();
                    this.session.sendMessage((WebSocketMessage)pingMessage);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 0L, this.properties.getHeartCycle().intValue(), TimeUnit.MILLISECONDS);
    }
}

