/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.extension.client;

import com.bxm.openlog.extension.client.Fallback;
import com.bxm.openlog.extension.client.HttpClientUtils;
import com.bxm.openlog.extension.client.HttpMethod;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpClientOpenLogClient
implements OpenLogClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClientOpenLogClient.class);
    private final ThreadPoolExecutor executor;
    private final HttpClient httpClient;
    private Timer timer;
    private Counter success;
    private Counter fail;

    private HttpClientOpenLogClient(ThreadPoolExecutor executor, int maxTotal, int defaultMaxPerRoute, int connectionRequestTimeout, int connectTimeout, int socketTimeout) {
        this.executor = executor;
        this.httpClient = HttpClientUtils.createHttpClient(maxTotal, defaultMaxPerRoute, connectionRequestTimeout, connectTimeout, socketTimeout);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void bindTo(MeterRegistry registry) {
        Class clazz = ClassUtils.getUserClass((Object)this);
        this.registerGauge(registry, this, clazz);
        this.registerTimer(registry, this, clazz);
        this.registerCounter(registry, this, clazz);
    }

    @Override
    public boolean request(String url) throws IOException {
        return this.request(url, HttpMethod.GET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean request(String url, HttpMethod httpMethod) throws IOException {
        long start = System.nanoTime();
        HttpResponse response = null;
        try {
            HttpGet request = null;
            switch (httpMethod) {
                case GET: {
                    request = new HttpGet(url);
                    break;
                }
                case POST: {
                    UriComponents build = UriComponentsBuilder.fromUriString((String)url).build();
                    MultiValueMap params = build.getQueryParams();
                    ArrayList pairs = Lists.newArrayListWithCapacity((int)params.size());
                    for (Map.Entry e : params.entrySet()) {
                        String key = (String)e.getKey();
                        List value = (List)e.getValue();
                        if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
                        String str = (String)value.get(0);
                        pairs.add(new BasicNameValuePair(key, UrlHelper.urlDecode((String)str)));
                    }
                    String nonParamUrl = UriComponentsBuilder.fromUriString((String)url).replaceQuery(null).build().toString();
                    HttpPost post = new HttpPost(nonParamUrl);
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity((List)pairs));
                    post.addHeader("Content-Type", "application/x-www-form-urlencoded");
                    request = post;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported httpMethod: " + (Object)((Object)httpMethod));
                }
            }
            response = this.httpClient.execute((HttpUriRequest)request);
            boolean bl = response.getStatusLine().getStatusCode() == 200;
            return bl;
        }
        finally {
            if (Objects.nonNull(response)) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            if (Objects.nonNull(this.timer)) {
                this.timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
    }

    @Override
    public void asyncRequest(String url, Consumer<Fallback> fallback) {
        this.asyncRequest(url, fallback, HttpMethod.GET);
    }

    @Override
    public void asyncRequest(String url, Consumer<Fallback> fallback, HttpMethod httpMethod) {
        this.executor.execute(() -> {
            block5: {
                try {
                    if (!this.request(url, httpMethod)) {
                        this.fail.increment();
                        if (Objects.nonNull(fallback)) {
                            fallback.accept(Fallback.builder().url(url).build());
                        }
                    } else {
                        this.success.increment();
                    }
                }
                catch (IOException e) {
                    this.fail.increment();
                    if (!Objects.nonNull(fallback)) break block5;
                    fallback.accept(Fallback.builder().url(url).exception(e).build());
                }
            }
        });
    }

    @Override
    public void asyncRequest(String url) {
        this.asyncRequest(url, HttpMethod.GET);
    }

    @Override
    public void asyncRequest(String url, HttpMethod httpMethod) {
        this.asyncRequest(url, null, httpMethod);
    }

    @Override
    public int queueSize() {
        return this.executor.getQueue().size();
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                log.warn("This executor was forced terminated!");
            }
        }
        catch (InterruptedException e) {
            log.error("awaitTermination: ", (Throwable)e);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    private void registerGauge(MeterRegistry registry, OpenLogClient client, Class<?> clazz) {
        Gauge.builder((String)"OpenLogClient.queue", (Object)0, value -> client.queueSize()).tags(new String[]{"name", clazz.getName()}).register(registry);
    }

    private void registerTimer(MeterRegistry registry, OpenLogClient client, Class<?> clazz) {
        this.timer = Timer.builder((String)"OpenLogClient.timer").tag("name", clazz.getName()).register(registry);
        log.info("Registering OpenLogClient {} timer meter successful.", (Object)client);
    }

    private void registerCounter(MeterRegistry registry, OpenLogClient client, Class<?> clazz) {
        this.success = Counter.builder((String)"OpenLogClient.counter").tag("name", "success").register(registry);
        this.fail = Counter.builder((String)"OpenLogClient.counter").tag("name", "fail").register(registry);
        log.info("Registering OpenLogClient {} counter meter successful.", (Object)client);
    }

    public static class Builder {
        private int maxTotal = 200;
        private int defaultMaxPerRoute = 20;
        private int connectionRequestTimeout = 100;
        private int connectTimeout = 200;
        private int socketTimeout = 500;
        private ThreadPoolExecutor executor;

        private Builder() {
            int processors = Runtime.getRuntime().availableProcessors();
            int max = 10000;
            this.executor = new ThreadPoolExecutor(processors, processors, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(max), (ThreadFactory)new NamedThreadFactory("openlog-client"));
        }

        public HttpClientOpenLogClient build() {
            return new HttpClientOpenLogClient(this.executor, this.maxTotal, this.defaultMaxPerRoute, this.connectionRequestTimeout, this.connectTimeout, this.socketTimeout);
        }

        public Builder setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public Builder setDefaultMaxPerRoute(int defaultMaxPerRoute) {
            this.defaultMaxPerRoute = defaultMaxPerRoute;
            return this;
        }

        public Builder setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setExecutor(ThreadPoolExecutor executor) {
            this.executor = executor;
            return this;
        }
    }
}

