/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.extension.client.ws;

import com.bxm.openlog.extension.client.ws.WsOpenLogClientProperties;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.PingMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.WebSocketConnectionManager;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class WsOpenLogClientHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(WsOpenLogClientHandler.class);
    private WebSocketSession session;
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(2);
    private final WsOpenLogClientProperties properties;
    private final WebSocketConnectionManager manager;

    public WsOpenLogClientHandler(WsOpenLogClientProperties properties) {
        this.properties = properties;
        String endpoint = properties.getEndpoint();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)endpoint), (Object)"endpoint is null or empty");
        StandardWebSocketClient socketClient = new StandardWebSocketClient();
        this.manager = new WebSocketConnectionManager((WebSocketClient)socketClient, (WebSocketHandler)this, endpoint, new Object[0]);
        this.startHeartbeat();
        this.startReconnection();
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.session = new ConcurrentWebSocketSessionDecorator(session, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void sendMessage(String data) throws Exception {
        if (this.isClosed()) {
            throw new IOException("connection error");
        }
        this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)data));
    }

    private boolean isClosed() {
        return this.session == null || !this.session.isOpen();
    }

    private void startHeartbeat() {
        this.scheduler.scheduleAtFixedRate(() -> {
            if (this.isClosed()) {
                return;
            }
            try {
                PingMessage pingMessage = new PingMessage();
                this.session.sendMessage((WebSocketMessage)pingMessage);
            }
            catch (Exception e) {
                log.error("ping error", (Throwable)e);
            }
        }, 2000L, this.properties.getHeartCycle().intValue(), TimeUnit.MILLISECONDS);
    }

    private void startReconnection() {
        this.scheduler.scheduleAtFixedRate(() -> {
            if (!this.isClosed()) {
                return;
            }
            try {
                this.manager.stop();
                this.manager.start();
            }
            catch (Exception e) {
                log.error("reconnection error", (Throwable)e);
            }
        }, 0L, this.properties.getReconnectionCycle().intValue(), TimeUnit.MILLISECONDS);
    }
}

