package com.bxm.openlog.sdk.listener;

import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.serial.Serialization;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.Objects;

/**
 * <p>订阅者 消息队列监听器。</p>
 * <p>消费消息时会根据行为类型转发给对应的 {@link LogSubscriber} 进行处理。</p>
 * @author allen
 * @date 2021-10-22
 * @since 1.0
 */
@Slf4j
public class SubscriberMessageListener implements SingleMessageListener {

    private final String id;
    private final String topic;
    private final String consumerId;
    private final Serialization serialization;
    private final Map<String, LogSubscriber> subscribers;

    SubscriberMessageListener(String id, String topic, String consumerId,
                              Serialization serialization, Map<String, LogSubscriber> subscribers) {
        this.id = id;
        this.topic = topic;
        this.consumerId = consumerId;
        this.serialization = serialization;
        this.subscribers = subscribers;
    }

    @Override
    public ConsumeStatus consume(Message message, Object context) {
        byte[] body = message.getBody();
        KeyValueMap keyValueMap = serialization.deserialize(body);
        String logMt = keyValueMap.getMt();
        LogSubscriber subscriber = subscribers.get(logMt);
        if (Objects.isNull(subscriber)) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot found subscriber by id: {} mt: {}", id, logMt);
            }
            return ConsumeStatus.CONSUME_SUCCESS;
        }
        return subscriber.consume(keyValueMap);
    }

    @Override
    public String getTopic() {
        return topic;
    }

    @Override
    public String getConsumerId() {
        return consumerId;
    }
}
