package com.bxm.openlog.sdk;

/**
 * 系统常量
 *
 * @author allen
 * @date 2021-09-27
 * @since 1.0
 */
public class Constants {

    /**
     * ADX-接入媒体
     */
    public enum Media {
        Unknown(0),
        Bxm(1),//bxmAdx协议
        Bxmssp(2),//bxmSsp协议
        Backup(3),//兜底入口
        Julang(4),//巨浪
        Paradigm(5),//第四范式
        Meishu(6),//美数
        Wps(7)
        ;
        private final int id;

        Media(int id) {
            this.id = id;
        }

        public static Media of(int id) {
            Media[] values = values();
            for (Media value : values) {
                if (id == value.id) {
                    return value;
                }
            }
            return Unknown;
        }

        public int getId() {
            return id;
        }
    }

    /**
     * Adx 服务商定义
     */
    public enum Adx {

        /**
         * 未知
         */
        Unknown(0),

        /**
         * 百度 BES
         */
        Bes(1),

        /**
         * 变现猫
         */
        Bxm(2),

        /**
         * 快手
         */
        Kuaishou(3),

        /**
         * 多盟
         */
        Domob(4),

        /**
         * 讯飞
         */
        Iflytek(5),

        /**
         * 趣头条
         */
        QTT(6),

        /**
         * Oppo
         */
        OPPO(7),

        /**
         * 喜马拉雅
         */
        XM(8),

        /**
         * 有境
         */
        YouJing(9),

        /**
         * AdMobile
         */
        AdMobile(10),

        /**
         * 美团
         */
        MeiTuan(11),

        /**
         * inmobi
         */
        INMOBI(12),

        /**
         * 传广
         */
        CHUAN_GUANG(13),

        /**
         * 巨浪
         */
        JU_LANG(14),

        /**
         * 美数
         */
        MeiShu(15),
        ;


        private final int id;

        Adx(int id) {
            this.id = id;
        }

        public static Adx of(int id) {
            Adx[] values = values();
            for (Adx value : values) {
                if (id == value.id) {
                    return value;
                }
            }
            return Unknown;
        }

        public int getId() {
            return id;
        }
    }
}
