package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * @author allen
 * @date 2022-04-25
 * @since 1.0
 */
public final class Game {

    /**
     * 行为类型
     */
    public enum Mt {
        ;

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Mt[] values = values();
            for (Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }


    public interface Param extends ProductionCommonParam {
    }
}
