package com.bxm.openlog.sdk.serial;

import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;

import java.util.Map;

/**
 * @author allen
 * @date 2021-09-26
 * @since 1.0
 */
public class JsonSerialization implements Serialization {

    @Override
    public byte[] serialize(Map<String, String[]> parameterMap) {
        return JsonHelper.convert2bytes(parameterMap);
    }

    @Override
    public byte[] serialize(KeyValueMap keyValueMap) {
        return JsonHelper.convert2bytes(keyValueMap);
    }

    @Override
    public KeyValueMap deserialize(byte[] data) {
        return JsonHelper.convert(data, KeyValueMap.class);
    }
}
