package com.bxm.openlog.sdk.serial;

import com.bxm.openlog.sdk.KeyValueMap;

import java.util.Map;

/**
 * @author allen
 * @date 2021-09-26
 * @since 1.0
 */
public interface Serialization {

    /**
     * 序列化成字节数组
     *
     * @param parameterMap 参数列表
     * @return 字节数组
     */
    byte[] serialize(Map<String, String[]> parameterMap);

    /**
     * 序列化成字节数组
     * @param keyValueMap 日志
     * @return 字节数组
     */
    byte[] serialize(KeyValueMap keyValueMap);

    /**
     * 将字节数组反序列化日志
     * @param data 字节数组
     * @return 日志
     */
    KeyValueMap deserialize(byte[] data);
}
