package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * 盘古的常量定义
 *
 * @author allen
 * @date 2021-11-05
 * @since 1.0
 */
public final class Pangu {

    /**
     * 盘古行为类型定义。
     *
     * <a href="https://bxmrds.yuque.com/staff-pe8atq/eqfqab/zeg3t4">详情</a>
     *
     * @author allen
     * @date 2021-10-28
     * @since 1.0
     */
    public enum Mt {

        /**
         * 请求
         */
        Request("1"),
        /**
         * 响应
         */
        Response("2"),
        /**
         * 出价
         */
        Offer("3"),
        /**
         * 曝光
         */
        Show("4"),
        /**
         * 点击
         */
        Click("5"),
        /**
         * 胜出
         */
        Win("6"),
        /**
         * DeepLink 开始
         */
        DpStart("7"),
        /**
         * DeepLink 成功
         */
        DpSuccess("8"),
        /**
         * DeepLink 失败
         */
        DpFail("9"),
        /**
         * 开始下载
         */
        DownloadStart("10"),
        /**
         * 完成下载
         */
        DownloadFinish("11"),
        /**
         * 开始安装
         */
        InstallStart("12"),
        /**
         * 完成安装
         */
        InstallFinish("13"),
        /**
         * 算法ocpc标签日志
         */
        ArithmeticLog("20"),
        /**
         * 算法其他所有标签日志
         */
        ArithmeticAllLog("21"),
        /**
         * 算法参竞
         */
        ArithmeticBid("22"),
        /**
         * 算法model异常
         */
        ArithmeticModelErr("23"),
        /**
         * 算法CTR过滤
         */
        ArithmeticCtr("24"),
        /**
         * 竞价结果原因埋点，由ADX发起的。
         */
        Bidded("30"),
        /**
         * RTA 请求
         */
        RtaRequest("100");

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Mt[] values = values();
            for (Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }

    /**
     * 盘古的行为参数。
     *
     * <a href="https://bxmrds.yuque.com/staff-pe8atq/eqfqab/is4y6k">详情</a>
     *
     * @author allen
     * @date 2021-11-05
     * @since 1.0
     */
    public interface Param extends ProductionCommonParam {

        int CHGTYPE_CPM = 1;
        int CHGTYPE_CPC = 2;

        String BXMID = "bxmid";
        String SBID = "sbid";
        String UID = "uid";
        String BIDID = "bidid";
        String OBIDID = "obidid";
        String ADID = "adid";
        String TAGID = "tagid";
        String CREATEID = "createid";
        String IP = "ip";
        String OS = "os";
        String UA = "ua";
        String WIN = "win";
        String PRICE = "price";
        String OFFER_PRICE = "offer_price";
        String OFFER_PRICE_PRECISION = "offer_price_precision";
        String ADXID = "adxid";
        String ANID = "anid";
        String MAC = "mac";
        String BUNDLE = "bundle";
        String ADXAPPID = "adxappid";
        String APPCT = "appct";
        String ADCT = "adct";
        String RTA_PTCE = "rta_ptce";
        String RTA_HIT = "rta_hit";
        String RTA_STATUS = "rta_status";
        String ALTAG = "altag";
        String ADLIST = "adlist";
        /**
         * 媒体本次竞价结算模式：1=CPM、2=CPC
         * @see #CHGTYPE_CPM
         * @see #CHGTYPE_CPC
         */
        String CHGTYPE = "chgtype";
        String ALGOENTITY = "algoentity";

        String PICID = "picid";
        String ADVERCOST = "adver_cost";
        String ADVER_OFFER_PRICE = "adver_offer_price";

        /**
         * x-requested-with
         */
        String X_REQW = "x_reqw";
        String ADX_TAG_ID = "adxtagid";
        String FLOOR = "floor";
    }
}
