package com.bxm.openlog.sdk.listener.eventbus;

import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventPark;
import lombok.Builder;
import lombok.Data;

import java.util.function.Function;
import java.util.function.Predicate;

/**
 * OpenLog 事件配置器
 *
 * @author allen
 * @date 2022-01-21
 * @since 1.0
 */
@Data
@Builder
public class OpenLogEventConfig {

    /**
     * 行为类型
     */
    private String mt;
    /**
     * 事件类型
     */
    private Class<? extends OpenLogEvent> eventType;
    /**
     * 设置发出对应事件的条件。如果没有设置，则任何情况都会发出对应的事件。
     */
    private Predicate<KeyValueMap> condition;
    /**
     * 指定这个事件类型使用的 EventPark。
     * 如果不设置或未空，则使用 {@link OpenLogEventBusBean#getEventPark()} 返回的实例。
     */
    private EventPark eventPark;
}
