/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.sdk.listener.eventbus;

import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEvent;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventBusFactory;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventConfig;
import com.bxm.openlog.sdk.serial.Serialization;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

class EventBusSubscriberMessageListener
implements SingleMessageListener,
BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(EventBusSubscriberMessageListener.class);
    private final String topic;
    private final String consumerId;
    private final Serialization serialization;
    private final EventPark eventPark;
    private final Map<String, OpenLogEventConfig> configFactoryMap;

    EventBusSubscriberMessageListener(String topic, String consumerId, Serialization serialization, EventPark eventPark, Map<String, OpenLogEventConfig> configFactoryMap) {
        this.topic = topic;
        this.consumerId = consumerId;
        this.serialization = serialization;
        this.eventPark = eventPark;
        this.configFactoryMap = configFactoryMap;
    }

    public ConsumeStatus consume(Message message, Object context) {
        try {
            byte[] body = message.getBody();
            KeyValueMap keyValueMap = this.serialization.deserialize(body);
            Production production = Production.of(keyValueMap.getProduction());
            String mt = keyValueMap.getMt();
            String key = OpenLogEventBusFactory.getKey(production, mt);
            OpenLogEventConfig config = this.configFactoryMap.get(key);
            if (Objects.isNull(config)) {
                return ConsumeStatus.CONSUME_SUCCESS;
            }
            boolean isSendEvent = true;
            Predicate<KeyValueMap> condition = config.getCondition();
            if (Objects.nonNull(condition)) {
                isSendEvent = condition.test(keyValueMap);
            }
            if (isSendEvent) {
                OpenLogEvent logEvent = EventBusSubscriberMessageListener.newInstance(config.getEventType(), this, keyValueMap);
                EventPark thisEventPark = config.getEventPark();
                if (Objects.nonNull(thisEventPark)) {
                    thisEventPark.post((EventObject)logEvent);
                } else {
                    this.eventPark.post((EventObject)logEvent);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Check condition failed!");
            }
        }
        catch (Exception e) {
            log.error("consume: ", (Throwable)e);
        }
        return ConsumeStatus.CONSUME_SUCCESS;
    }

    private static <T extends OpenLogEvent> T newInstance(Class<T> clazz, Object source, KeyValueMap keyValueMap) {
        try {
            Constructor<T> constructor = clazz.getConstructor(Object.class, KeyValueMap.class);
            return (T)((OpenLogEvent)constructor.newInstance(new Object[]{source, keyValueMap}));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("newInstance: ", (Throwable)e);
            return null;
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public String getConsumerId() {
        return this.consumerId;
    }
}

