package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * 支付定义
 * @Author: pf.w
 * @Date: 2022/11/1 10:01
 */

public final class Pay {

    public enum Mt{

        payReport("42"),
        payPeriod("43");

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Pay.Mt[] values = values();
            for (Pay.Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }

    public interface Param extends ProductionCommonParam {
        //正常发钱买量类型
        String WAY_NORMAL = "normal";
        //通过脚本跑的类型
        String WAY_SCRIPT = "script";

        /**
         * 区分发钱买量 和 脚本执行
         */
        String PAY_WAY = "way";
        /**
         * 支付ID
         */
        String PAY_ID = "pay_id";
        /**
         * 脚本执行时间段
         */
        String PAY_PERIOD = "period";

        String MT = "mt";
    }
}
