package com.bxm.openlog.sdk;

/**
 * 系统常量
 *
 * @author allen
 * @date 2021-09-27
 * @since 1.0
 */
public class Constants {

    /**
     * ADX-接入媒体
     * ID需要和ADX项目中的一致
     */
    public enum Media {
        Default(-1),
        Unknown(0),
        Bxm(1),//bxmAdx协议
        Bxmssp(2),//bxmSsp协议
        Backup(3),//兜底入口
        Julang(4),//巨浪
        Paradigm(5),//第四范式
        Meishu(6),//美数
        Wps(7),//wps
        Jishubao(8),//欢乐计步宝
        Baisou(9),//百搜视频
        Manxing(10),//漫星
        Guangyin(11),//光音ssp
        Liandao(12),//联道ssp
        Ssp2345(13),//ssp2345
        Bochuang(14),//博创
        Xiaomai(15),//小迈
        Yien(16),//壹恩
        Jugao(17),//聚告
        Yiqi(18),//益起
        Jumai(19),//俱脉
        Chuwang(20),//触网
        Moliguo(21),//魔力果
        Woke(22),//沃氪
        Kingstone(23),//金岩石
        Jialiang(24),//佳量
        Shengtong(25),//盛通
        Tairan(26),//泰然
        Yixuan(27),//一玄
        Zixuan(28),//自旋
        Puliang(29),//曝量
        Yidao(30),//壹道
        Kuaiya(31),//快雅
        Inmobi(32),//inmobi
        Xinbianjie(33),//新边界
        Xinzhi(34),//新知
        Zhongqing(35),//中青看点
        Wanwei(36),//万维
        Sigmob(37),//Sigmob
        Shuchuan(38),//数川
        Soul(39),//soul
        Baixun(40),//百寻
        Senle(41),//森乐
        Bes(42),//百度
        Topon(43),//Topon
        Yueke(44),//阅客
        Yangy(45),//洋扬
        Xinshu(46),//新数
        Jingmeng(47),//京盟
        Yuansi(48),//沅思
        Qutoutiao(49),//趣头条
        Zhongguan(50),//中关
        Index(51),//因代克斯
        Zhangyue(52),//掌阅
        Mangguo(55), //芒果
        Baize(56),//白泽
        b612(57),//b612
        Cashcat(58),//cashcat
        Saomiao(59),//扫描全能王
        Netease(60),//网易
        Chubao(61),//触宝
        Chuanguang(66),//传广
        Oppo(76),//oppo
        Openrtb(78),//Openrtb
        Midu(82),//米读
        Xiaomi(83),//小米
        Adhub(84),//adhub
        Xmly(86),//喜马拉雅
        Kuaishou(87),//快手
        Momo(97),//陌陌
        Meitu(99),//美图
        Uc(101),//UC汇川
        Ucdirect(103),//UC汇川（先投）
        Ucnew(112),//UC汇川（新账号，与之前区分开）
        Ubix(116),//Ubix
        Sina(119) //新浪
        ;
        private final int id;

        Media(int id) {
            this.id = id;
        }

        public static Media of(int id) {
            Media[] values = values();
            for (Media value : values) {
                if (id == value.id) {
                    return value;
                }
            }
            return Unknown;
        }

        public int getId() {
            return id;
        }
    }

    /**
     * Adx 服务商定义
     */
    public enum Adx {

        /**
         * 未知
         */
        Unknown(0),

        /**
         * 百度 BES
         */
        Bes(1),

        /**
         * 变现猫
         */
        Bxm(2),

        /**
         * 快手
         */
        Kuaishou(3),

        /**
         * 多盟
         */
        Domob(4),

        /**
         * 讯飞
         */
        Iflytek(5),

        /**
         * 趣头条
         */
        QTT(6),

        /**
         * Oppo
         */
        OPPO(7),

        /**
         * 喜马拉雅
         */
        XM(8),

        /**
         * 有境
         */
        YouJing(9),

        /**
         * AdMobile
         */
        AdMobile(10),

        /**
         * 美团
         */
        MeiTuan(11),

        /**
         * inmobi
         */
        INMOBI(12),

        /**
         * 传广
         */
        CHUAN_GUANG(13),

        /**
         * 巨浪
         */
        JU_LANG(14),

        /**
         * 美数
         */
        MeiShu(15),


        /**
         * 变现猫
         */
        BxmRtb(16),
        ;


        private final int id;

        Adx(int id) {
            this.id = id;
        }

        public static Adx of(int id) {
            Adx[] values = values();
            for (Adx value : values) {
                if (id == value.id) {
                    return value;
                }
            }
            return Unknown;
        }

        public int getId() {
            return id;
        }
    }


    /**
     * Encryption Model 赢价加密模式 0-未加密，1-BXM默认支持的加密模式AES（详见ADX文档）,2-客制化（流量方自己的加密模式）
     */
    public interface EncryptionModel {
        int UNENCRYPTED = 0;
        int AES = 1;
        int CUSTOMIZE = 2;
    }
}
