package com.bxm.openlog.sdk.consts;

import com.bxm.openlog.sdk.params.ProductionCommonParam;

/**
 * 互动广告常量定义
 *
 * @author allen
 * @date 2022-01-06
 * @since 1.0
 */
public final class Inads {

    /**
     * 行为类型
     */
    public enum Mt {

        /**
         * 中间页曝光
         */
        IndexShow("9"),

        /**
         * 活动页面曝光
         */
        ActivityPageShow("3"),

        /**
         * 参加活动
         */
        ActivityAttend("4"),

        /**
         * 广告请求
         */
        AdRequest("5"),

        /**
         * 广告曝光
         */
        AdShow("6"),

        /**
         * 广告点击
         */
        AdClick("7"),

        /**
         * 广告中间页配置请求
         */
        AdMiddlePageRequest("60"),
        /**
         * 广告中间页配置曝光
         */
        AdMiddlePageShow("61"),
        /**
         * 广告中间页配置点击
         */
        AdMiddlePageClick("62"),
        /**
         * 广告中间页配置手机号请求数据
         */
        AdMiddlePagePhoneData("63"),

        /**
         * 手机号请求运营商地域数据
         */
        PhoneISPData("70"),

        /**
         * 广告转化
         */
        AdConversion("8"),

        /**
         * DeepLink开始唤起
         */
        DpStart("10"),
        /**
         * DeepLink唤起成功
         */
        DpSuccess("11"),
        /**
         * DeepLink唤起失败
         */
        DpFail("12"),
        /**
         * 开始下载
         */
        DownloadStart("13"),
        /**
         * 下载完成
         */
        DownloadFinish("14"),
        /**
         * 开始安装
         */
        InstallStart("15"),
        /**
         * 安装完成
         */
        InstallFinish("16"),
        /**
         * 广告落地页曝光
         */
        AdLandpageShow("20"),
        /**
         * 广告落地页点击图片
         */
        AdLandpageClickImage("21"),
        /**
         * 自建站加载完成
         */
        AdLandpageLoaded("22"),
        /**
         * 自建站离开
         */
        AdLandpageLeave("23"),
        /**
         * 自建站辅助信息
         */
        AdLandpageExtraInfo("24"),
        /**
         * 算法日志打印
         */
        AlgirithmEntity("25"),
        /**
         * 互动api接口请求
         */
        AdApiRequest("50"),
        /**
         * 互动api接口中间页
         */
        AdApiMiddlePage("51"),
        /**
         * 互动api接口素材曝光
         */
        AdApiShow("52"),
        /**
         * 互动api接口素材点击
         */
        AdApiClick("53"),
        /**
         * 广告辅助转化
         */
        AdExtendConversion("80"),
        /**
         * 拼多多订单明细
         */
        PddOrderDetail("81"),
        /**
         * 用户获得实物奖品日志
         */
        FetchPrize("82"),
        /**
         * 用户获得广告券日志
         */
        FetchAdTicket("83"),

        /**
         * 发财树收益回传
         */
        FacaishuIncomeRequest("101");

        private final String original;

        Mt(String original) {
            this.original = original;
        }

        public String original() {
            return original;
        }

        public static Mt of(String original) {
            Mt[] values = values();
            for (Mt value : values) {
                if (value.original().equals(original)) {
                    return value;
                }
            }
            return null;
        }
    }

    /**
     * 行为参数
     * <a href="https://bxmrds.yuque.com/mizhsy/eqfqab/lr4exg">最新说明请参考文档</a>
     */
    public interface Param extends ProductionCommonParam {

        String BIDID = "bidid";
        String OBIDID = "obidid";
        String BXMID = "bxmid";
        String UID = "uid";
        String ADID = "adid";
        String TAGID = "tagid";
        String CREATEID = "createid";
        String OS = "os";
        String SPM = "spm";
        String ACTIVITYID = "activityid";
        /**
         * 弹窗类型
         */
        String SCENE = "scene";
        String X = "x";
        String Y = "y";
        /**
         * 宽,高
         */
        String WH = "wh";
        String POPUPID = "popupid";
        /**
         * 单位：厘，无小数点
         */
        String OFFER_PRICE = "offer_price";
        String EXT = "ext";
        String DOMAIN = "domain";
        String ACTYPE = "actype";

        String ADURL = "adurl";
        String FMID = "fmid";

        String FM_MODEL_ID = "fm_model_id";
        String WOKEID = "wokeid";
        /**
         * 1 直投、0 或空 非直投
         */
        String SRC_TYPE = "src_type";
        String LANDID = "landid";
        String EN_ADID = "en_adid";
        String EN_CID = "en_cid";
        String ADX_APPID = "adx_appid";
        String SSP_APPID = "ssp_appid";
        String SSP_TAGID = "ssp_tagid";

        String ATPID = "atpid";
        String OCPA_OFFER_PRICE = "ocpa_offer_price";
        String TARGET_CONV_TYPE = "target_conv_type";
        String SETTLE_TYPE = "settle_type";
        String PICID = "picid";

        String REMAIN_TIME = "remain_time";
        String CLICK_AREA = "click_area";
        String CLICK_LOCATION = "click_location";
        String TOID = "toid";
        String VENUEID = "venueid";
        String TAG_CID = "tag_cid";
        String BAN = "ban";
        String ADVER_OFFER_PRICE = "adver_offer_price";
        String PAYED = "payed";

        String CONVERSION_TYPE = "conversion_type";
        String CONVERSION_STATUS = "conversion_status";
        String PAY_AMOUNT = "pay_amount";

        String BUNDLE = "bundle";
        String SBID = "sbid";

        String ALGORITHMENTITY = "algorithm_entity";
        String RTBTICKEGGROUPID = "rtb_ticket_group_id";
        String SEQ = "seq";
        String RTB_EXT = "rtb_ext";

        String CONVERSION_VALID = "conversion_valid";
        String REQUEST_ID = "req_id";
        String LP_ID = "lpid";
        String LP_SCENE = "lp_scene";
        String ANTI_SEALING = "anti_sealing";

        String SHALLOW_TYPE = "shallow_type";
        String DEEP_TYPE = "deep_type";

        String ORDER_CREATE_TIME = "order_create_time";
        String ORDER_PAY_TIME = "order_pay_time";
        String ORDER_ID = "order_id";
        String ORDER_STATUS = "order_status";
        String GOODS_ID = "goods_id";
        String GOODS_NAME = "goods_name";
        String GOODS_PRICE = "goods_price";
        String GOODS_QUANTITY = "goods_quantity";
        String PLATFORM_SOURCE = "platform_source";
        String PHONE_NUM = "phone_num";
        String JSON_DATA = "json_data";
        String PUT_IN_TYPE = "put_in_type";
    }

    /**
     * 扩展参数
     */
    public interface ExtParam {
        String BUCKET_ID = "bucket_id";
        String SEQ_ID = "seq_id";
        String SEQ_DOWN = "seq_down";
        String SEQ_TEST = "seq_test";
        /**
         * 行业中间页配置ID
         */
        String TENCENT_SUK ="tencent_suk";
        /**
         * 行业中间页上一次的bxmid
         */
        String TENCENT_REQID = "tencent_reqid";
        /**
         * 行业中间页上一次的出价
         */
        String TENCENT_OFFER_PRICE = "tencent_offer_price";
        /**
         * 行业中间页上一次的券ID
         */
        String TENCENT_ID = "tencent_id";
        /**
         * 行业中间页上一次的广告券结算类型。
         * 1、CPC，2、CPA，3、oCPC，4、CPM，5、oCPR
         */
        String TENCENT_SETTLE_TYPE = "tencent_settle_type";
        /**
         * 行业中间页本次出的自建站落地页ID
         */
        String TENCENT_LP_ID ="tencent_lp_id";

        /**
         * 自建站中间页落地页ID（中间页里面会配置跳转到自建站ID）
         */
        String B_LP_ID ="b_lp_id";
    }
}
